/****************************************************************************
 * This file contains the microcode for MyCPU.
 * Author: Dennis Kuschel, K.-G.-Kiesinger-Allee 14, 28279 Bremen, Germany
 ****************************************************************************/

/*
 *  Version:  2.3
 */

#include "mcdefs.h"

#define NO_OF_OPCODES   256
#define NO_OF_MCODE     20


/* ================== MACROS =================== */

#define ADRMODE_ABSOLUT_PLUS(reg)                \
 FETCH,                                          \
 reg | CLK_AREG1,                                \
 MOVE_ROMPC_TO_AREG2,                            \
 INC_PC | CONST_00 | MOVE_CONST_TO_FLAGSR,       \
 ALU_TO(MODE_ADC,CFLAG_REGISTER,ALU_TO_ADDR_LO), \
 MOVE_ROMPC_TO_AREG1 | INC_PC,                   \
 ALU_TO(MODE_CINC,CFLAG_ALU,ALU_TO_ADDR_HI)
/* now follows NOP, MOVE_RAM_TO_xxx  or NOP, MOVE_ROMAD_TO_xxx */


#define ADRMODE_ABSOLUT            \
 FETCH,                            \
 NOP,                              \
 MOVE_ROMPC_TO_ADDR_LO | INC_PC,   \
 NOP,                              \
 MOVE_ROMPC_TO_ADDR_HI,            \
 INC_PC
/* now follows MOVE_RAM_TO_xxx  or  MOVE_ROMAD_TO_xxx */


#define ADRMODE_IND_ZP_PLUS(reg)    \
 FETCH,                            \
 CONST_00 | MOVE_CONST_TO_ADDR_HI, \
 MOVE_ROMPC_TO_P | INC_PC,         \
 MOVE_P_TO_ADDR_LO,                \
 MOVE_P_TO_AREG1,                  \
 MOVE_RAM_TO_AREG2,                \
 ALU_TO(MODE_INCC,CFLAG_VISIBLE,ALU_TO_ADDR_LO), \
 reg | CLK_AREG1,                  \
 ALU(MODE_ADC,CFLAG_ALU) | MOVE_RAM_TO_AREG1, \
 MOVE_ALU_TO_ADDR_LO,              \
 ALU_TO(MODE_CINC,CFLAG_ALU,ALU_TO_ADDR_HI)
/* now follows NOP, MOVE_RAM_TO_xxx  or  NOP, MOVE_ROMAD_TO_xxx */




/* ====== Microcode for Interrupt Control ====== */

unsigned long g_ulMCIRQ[MCODES_PER_OP] =
{
 FETCH,
 CLI,
 CONST_01 | MOVE_CONST_TO_ADDR_HI,
 MOVE_SP_TO_ADDR_LO,
 MOVE_SP_TO_AREG1,
 MOVE_FLAGS_TO_RAM,
 ALU_TO(MODE_DEC, CFLAG_VISIBLE, ALU_TO_ADDR_LO),
 MOVE_ALU_TO_AREG1,
 ALU_TO(MODE_DEC, CFLAG_VISIBLE, ALU_TO_SP),
 MOVE_PC_LO_TO_AREG1,
 ALU_TO(MODE_DEC, CFLAG_VISIBLE, ALU_TO_P),
 MOVE_PC_HI_TO_AREG1,
 ALU(MODE_CDEC, CFLAG_ALU) | CONST_03 | MOVE_CONST_TO_PC_LO,
 MOVE_ALU_TO_RAM,
 MOVE_SP_TO_ADDR_LO,
 CONST_00 | MOVE_CONST_TO_PC_HI,
 MOVE_P_TO_RAM,
 MOVE_SP_TO_AREG1 | LOAD_PC,
 ALU_TO(MODE_DEC, CFLAG_VISIBLE, ALU_TO_SP) | NEXTOP,
};



/* ======== Microcode for each OP-Code ========= */


unsigned long g_ulMCTAB[NO_OF_OPCODES][NO_OF_MCODE+1] =
{

/* 00 - BRK */  /* soft-INT: push flags + pc and jump to addr 0006 */
{
 0x00,
 FETCH,
 CONST_01 | MOVE_CONST_TO_ADDR_HI,
 MOVE_SP_TO_ADDR_LO,
 DEC_SP,
 MOVE_FLAGS_TO_RAM,
 MOVE_SP_TO_ADDR_LO,
 DEC_SP,
 MOVE_PC_HI_TO_RAM,
 MOVE_SP_TO_ADDR_LO,
 DEC_SP,
 MOVE_PC_LO_TO_RAM,
 CONST_03 | MOVE_CONST_TO_AREG1,
 ALU_TO(MODE_SHL,CFLAG_VISIBLE,ALU_TO_PC_LO),
 CONST_00 | MOVE_CONST_TO_PC_HI,
 LOAD_PC,
 NEXTOP,
},

/* 01 - NOP */
{
 0x01,
 FETCH,
 NOP,
 NEXTOP,
},

/* 02 - CLI */
{
 0x02,
 FETCH,
 CLI,
 NEXTOP,
},

/* 03 - SEI */
{
 0x03,
 FETCH,
 SEI,
 NEXTOP,
},

/* 04 - CLC */
{
 0x04,
 FETCH,
 NOP,
 ALU(MODE_AND,CFLAG_VISIBLE) | LOAD_CFLAG_ALU | NEXTOP,
},

/* 05 - SEC */
{
 0x05,
 FETCH,
 NOP,
 ALU(MODE_MULL,CFLAG_VISIBLE) | LOAD_CFLAG_ALU | NEXTOP,
},

/* 06 - CLZ */
{
 0x06,
 FETCH,
 DO_ON_ZFLAG( MOVE_FLAGS_TO_AREG1                                                 , NOP    ),
 DO_ON_ZFLAG( CONST_02 | MOVE_CONST_TO_AREG2                                      , NEXTOP ),
 DO_ON_ZFLAG( ALU_TO(MODE_XOR,CFLAG_VISIBLE,ALU_TO_FLAGSR)|LOAD_ZVFLAGS_REG|NEXTOP, NONE   ),
},

/* 07 - SEZ */
{
 0x07,
 FETCH,
 DO_ON_ZFLAG( NOP    , MOVE_FLAGS_TO_AREG1                                                 ),
 DO_ON_ZFLAG( NEXTOP , CONST_02 | MOVE_CONST_TO_AREG2                                      ),
 DO_ON_ZFLAG( NONE   , ALU_TO(MODE_OR,CFLAG_VISIBLE,ALU_TO_FLAGSR)|LOAD_ZVFLAGS_REG|NEXTOP ),
},


/* 7A - PHR  (push all registers) */
{
 0x7A,
 FETCH,
 CONST_01 | MOVE_CONST_TO_ADDR_HI,
 MOVE_SP_TO_ADDR_LO,
 MOVE_SP_TO_AREG1,
 MOVE_ACCU_TO_RAM,
 ALU_TO(MODE_DEC, CFLAG_VISIBLE,ALU_TO_ADDR_LO),
 MOVE_ALU_TO_AREG1,
 MOVE_X_TO_RAM,
 ALU_TO(MODE_DEC, CFLAG_VISIBLE,ALU_TO_ADDR_LO),
 MOVE_ALU_TO_AREG1,
 MOVE_Y_TO_RAM,
 ALU_TO(MODE_DEC, CFLAG_VISIBLE,ALU_TO_SP) | NEXTOP,
},

/* 8A - PLR  (pop all registers) */
{
 0x8A,
 FETCH,
 CONST_01 | MOVE_CONST_TO_ADDR_HI,
 MOVE_SP_TO_AREG1,
 ALU_TO(MODE_INC, CFLAG_VISIBLE,ALU_TO_ADDR_LO),
 MOVE_ALU_TO_AREG1,
 MOVE_RAM_TO_Y,
 ALU_TO(MODE_INC, CFLAG_VISIBLE,ALU_TO_ADDR_LO),
 MOVE_ALU_TO_AREG1,
 MOVE_RAM_TO_X,
 ALU_TO(MODE_INC, CFLAG_VISIBLE,ALU_TO_ADDR_LO),
 MOVE_ALU_TO_SP,
 MOVE_RAM_TO_ACCU,
 NEXTOP,
},

/* 08 - PHA */
{
 0x08,
 FETCH,
 MOVE_SP_TO_ADDR_LO,
 CONST_01 | MOVE_CONST_TO_ADDR_HI,
 MOVE_SP_TO_AREG1,
 MOVE_ACCU_TO_RAM,
 ALU_TO(MODE_DEC,CFLAG_VISIBLE,ALU_TO_SP) | NEXTOP,
},

/* 09 - PHX */
{
 0x09,
 FETCH,
 MOVE_SP_TO_ADDR_LO,
 CONST_01 | MOVE_CONST_TO_ADDR_HI,
 MOVE_SP_TO_AREG1,
 MOVE_X_TO_RAM,
 ALU_TO(MODE_DEC,CFLAG_VISIBLE,ALU_TO_SP) | NEXTOP,
},

/* 0A - PHY */
{
 0x0A,
 FETCH,
 MOVE_SP_TO_ADDR_LO,
 CONST_01 | MOVE_CONST_TO_ADDR_HI,
 MOVE_SP_TO_AREG1,
 MOVE_Y_TO_RAM,
 ALU_TO(MODE_DEC,CFLAG_VISIBLE,ALU_TO_SP) | NEXTOP,
},

/* 0B - PHP */
{
 0x0B,
 FETCH,
 MOVE_SP_TO_ADDR_LO,
 CONST_01 | MOVE_CONST_TO_ADDR_HI,
 MOVE_SP_TO_AREG1,
 MOVE_FLAGS_TO_RAM,
 ALU_TO(MODE_DEC,CFLAG_VISIBLE,ALU_TO_SP) | NEXTOP,
},

/* 0C - PLA */
{
 0x0C,
 FETCH,
 MOVE_SP_TO_AREG1,
 ALU_TO(MODE_INC, CFLAG_VISIBLE, ALU_TO_ADDR_LO),
 CONST_01 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ALU_TO_SP,
 MOVE_RAM_TO_AREG1,
 ALU_TO_UPDFLAGS(ALU_TO_ACCU, LOAD_ZVFLAGS_ALU | NEXTOP),
},

/* 0D - PLX */
{
 0x0D,
 FETCH,
 MOVE_SP_TO_AREG1,
 ALU_TO(MODE_INC, CFLAG_VISIBLE, ALU_TO_ADDR_LO),
 CONST_01 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ALU_TO_SP,
 MOVE_RAM_TO_AREG1,
 ALU_TO_UPDFLAGS(ALU_TO_X, LOAD_ZVFLAGS_ALU | NEXTOP),
},

/* 0E - PLY */
{
 0x0E,
 FETCH,
 MOVE_SP_TO_AREG1,
 ALU_TO(MODE_INC, CFLAG_VISIBLE, ALU_TO_ADDR_LO),
 CONST_01 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ALU_TO_SP,
 MOVE_RAM_TO_AREG1,
 ALU_TO_UPDFLAGS(ALU_TO_Y, LOAD_ZVFLAGS_ALU | NEXTOP),
},

/* 0F - PLP */
{
 0x0F,
 FETCH,
 MOVE_SP_TO_AREG1,
 ALU_TO(MODE_INC, CFLAG_VISIBLE, ALU_TO_ADDR_LO),
 CONST_01 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ALU_TO_SP,
 MOVE_RAM_TO_FLAGSR,
 LOAD_FLAGS_REG | NEXTOP,
},

/* 10 - JMP abs */
{
 0x10,
 FETCH,
 NOP,
 MOVE_ROMPC_TO_PC_LO | INC_PC,
 NOP,
 MOVE_ROMPC_TO_PC_HI,
 LOAD_PC,
 NEXTOP,
},

/* 11 - JMP (abs) */
{
 0x11,
 FETCH,
 NOP,
 MOVE_ROMPC_TO_P | INC_PC,
 MOVE_P_TO_ADDR_LO,
 MOVE_ROMPC_TO_ADDR_HI,
 MOVE_P_TO_AREG1,
 MOVE_RAM_TO_PC_LO,
 ALU_TO(MODE_INCC,CFLAG_VISIBLE,ALU_TO_ADDR_LO),
 MOVE_ROMPC_TO_AREG1,
 ALU_TO(MODE_CINC,CFLAG_ALU,ALU_TO_ADDR_HI),
 NOP,
 MOVE_RAM_TO_PC_HI,
 LOAD_PC,
 NEXTOP,
},

/* 12 - JMP (abs,X) */
{
 0x12,
 FETCH,
 MOVE_X_TO_AREG1,
 MOVE_ROMPC_TO_AREG2,
 INC_PC | CONST_00 | MOVE_CONST_TO_FLAGSR,
 ALU_TO(MODE_ADC,CFLAG_REGISTER,ALU_TO_ADDR_LO),
 MOVE_ROMPC_TO_AREG1,
 ALU_TO(MODE_CINC,CFLAG_ALU,ALU_TO_ADDR_HI),
 MOVE_X_TO_AREG1,
 MOVE_RAM_TO_PC_LO,
 CONST_01 | MOVE_CONST_TO_FLAGSR,
 ALU_TO(MODE_ADC,CFLAG_REGISTER,ALU_TO_ADDR_LO),
 MOVE_ROMPC_TO_AREG1,
 ALU_TO(MODE_CINC,CFLAG_ALU,ALU_TO_ADDR_HI),
 NOP,
 MOVE_RAM_TO_PC_HI,
 LOAD_PC,
 NEXTOP,
},

/* 13 - JMPC (abs,X) */
{
 0x13,
 FETCH,
 MOVE_X_TO_AREG1,
 MOVE_ROMPC_TO_AREG2,
 INC_PC | CONST_00 | MOVE_CONST_TO_FLAGSR,
 ALU_TO(MODE_ADC,CFLAG_REGISTER,ALU_TO_ADDR_LO),
 MOVE_ROMPC_TO_AREG1,
 ALU_TO(MODE_CINC,CFLAG_ALU,ALU_TO_ADDR_HI),
 MOVE_X_TO_AREG1,
 MOVE_ROMAD_TO_PC_LO,
 CONST_01 | MOVE_CONST_TO_FLAGSR,
 ALU_TO(MODE_ADC,CFLAG_REGISTER,ALU_TO_ADDR_LO),
 MOVE_ROMPC_TO_AREG1,
 ALU_TO(MODE_CINC,CFLAG_ALU,ALU_TO_ADDR_HI),
 NOP,
 MOVE_ROMAD_TO_PC_HI,
 LOAD_PC,
 NEXTOP,
},

/* 14 - JNV */  /* jump if sign is cleared (positiv number) */
{
 0x14,
 FETCH,
 DO_ON_VFLAG( INC_PC          , NOP                          ),
 DO_ON_VFLAG( INC_PC          , MOVE_ROMPC_TO_PC_LO | INC_PC ),
 DO_ON_VFLAG( NEXTOP          , NOP                          ),
 DO_ON_VFLAG( NONE            , MOVE_ROMPC_TO_PC_HI          ),
 DO_ON_VFLAG( NONE            , LOAD_PC                      ),
 DO_ON_VFLAG( NONE            , NEXTOP                       ),
},

/* 15 - JPV */  /* jump if sign is set (negativ number) */
{
 0x15,
 FETCH,
 DO_ON_VFLAG( NOP                          , INC_PC          ),
 DO_ON_VFLAG( MOVE_ROMPC_TO_PC_LO | INC_PC , INC_PC          ),
 DO_ON_VFLAG( NOP                          , NEXTOP          ),
 DO_ON_VFLAG( MOVE_ROMPC_TO_PC_HI          , NONE            ),
 DO_ON_VFLAG( LOAD_PC                      , NONE            ),
 DO_ON_VFLAG( NEXTOP                       , NONE            ),
},

/* 16 - JNC */  /* jump if carry is cleared */
{
 0x16,
 FETCH,
 DO_ON_CFLAG( INC_PC          , NOP                          ),
 DO_ON_CFLAG( INC_PC          , MOVE_ROMPC_TO_PC_LO | INC_PC ),
 DO_ON_CFLAG( NEXTOP          , NOP                          ),
 DO_ON_CFLAG( NONE            , MOVE_ROMPC_TO_PC_HI          ),
 DO_ON_CFLAG( NONE            , LOAD_PC                      ),
 DO_ON_CFLAG( NONE            , NEXTOP                       ),
},

/* 17 - JPC */  /* jump if carry is set */
{
 0x17,
 FETCH,
 DO_ON_CFLAG( NOP                          , INC_PC          ),
 DO_ON_CFLAG( MOVE_ROMPC_TO_PC_LO | INC_PC , INC_PC          ),
 DO_ON_CFLAG( NOP                          , NEXTOP          ),
 DO_ON_CFLAG( MOVE_ROMPC_TO_PC_HI          , NONE            ),
 DO_ON_CFLAG( LOAD_PC                      , NONE            ),
 DO_ON_CFLAG( NEXTOP                       , NONE            ),
},

/* 18 - JNZ */  /* jump if zeroflag is cleared */
{
 0x18,
 FETCH,
 DO_ON_ZFLAG( INC_PC          , NOP                          ),
 DO_ON_ZFLAG( INC_PC          , MOVE_ROMPC_TO_PC_LO | INC_PC ),
 DO_ON_ZFLAG( NEXTOP          , NOP                          ),
 DO_ON_ZFLAG( NONE            , MOVE_ROMPC_TO_PC_HI          ),
 DO_ON_ZFLAG( NONE            , LOAD_PC                      ),
 DO_ON_ZFLAG( NONE            , NEXTOP                       ),
},

/* 19 - JPZ */  /* jump if zeroflag is set */
{
 0x19,
 FETCH,
 DO_ON_ZFLAG( NOP                          , INC_PC          ),
 DO_ON_ZFLAG( MOVE_ROMPC_TO_PC_LO | INC_PC , INC_PC          ),
 DO_ON_ZFLAG( NOP                          , NEXTOP          ),
 DO_ON_ZFLAG( MOVE_ROMPC_TO_PC_HI          , NONE            ),
 DO_ON_ZFLAG( LOAD_PC                      , NONE            ),
 DO_ON_ZFLAG( NEXTOP                       , NONE            ),
},


/* 1A - JSR */
{
 0x1A,
 FETCH,
 CONST_01 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ROMPC_TO_PC_LO | INC_PC,
 MOVE_SP_TO_ADDR_LO,
 MOVE_ROMPC_TO_PC_HI,
 MOVE_SP_TO_AREG1,
 MOVE_PC_HI_TO_RAM,
 ALU_TO(MODE_DEC,CFLAG_VISIBLE,ALU_TO_ADDR_LO),
 MOVE_ALU_TO_AREG1,
 MOVE_PC_LO_TO_RAM | LOAD_PC,
 ALU_TO(MODE_DEC,CFLAG_VISIBLE,ALU_TO_SP) | NEXTOP,
},

/* 1B - JSR() */
{
 0x1B,
 FETCH,
 NOP,
 MOVE_ROMPC_TO_P | INC_PC,
 MOVE_P_TO_ADDR_LO,
 MOVE_ROMPC_TO_ADDR_HI,
 MOVE_P_TO_AREG1,
 MOVE_RAM_TO_PC_LO,
 ALU_TO(MODE_INCC,CFLAG_VISIBLE,ALU_TO_ADDR_LO),
 MOVE_ROMPC_TO_AREG1,
 ALU_TO(MODE_CINC,CFLAG_ALU,ALU_TO_ADDR_HI),
 MOVE_SP_TO_AREG1,
 MOVE_RAM_TO_PC_HI,
 CONST_01 | MOVE_CONST_TO_ADDR_HI,
 MOVE_SP_TO_ADDR_LO,
 ALU(MODE_DEC, CFLAG_VISIBLE),
 MOVE_PC_HI_TO_RAM,
 MOVE_ALU_TO_ADDR_LO,
 MOVE_ALU_TO_AREG1,
 MOVE_PC_LO_TO_RAM | LOAD_PC,
 ALU_TO(MODE_DEC, CFLAG_VISIBLE,ALU_TO_SP) | NEXTOP,
},

/* 1E - RTI */
{
 0x1E,
 FETCH,
 CONST_01 | MOVE_CONST_TO_ADDR_HI,
 MOVE_SP_TO_AREG1,
 ALU_TO(MODE_INC, CFLAG_VISIBLE,ALU_TO_ADDR_LO),
 MOVE_ALU_TO_AREG1,
 MOVE_RAM_TO_PC_LO,
 ALU_TO(MODE_INC, CFLAG_VISIBLE,ALU_TO_ADDR_LO),
 MOVE_ALU_TO_AREG1,
 MOVE_RAM_TO_PC_HI,
 ALU_TO(MODE_INC, CFLAG_VISIBLE,ALU_TO_ADDR_LO),
 MOVE_ALU_TO_SP,
 MOVE_RAM_TO_FLAGSR | LOAD_PC,
 LOAD_FLAGS_REG | SEI | NEXTOP,
},

/* 1F - RTS */
{
 0x1F,
 FETCH,
 CONST_01 | MOVE_CONST_TO_ADDR_HI,
 MOVE_SP_TO_AREG1,
 ALU_TO(MODE_INC, CFLAG_VISIBLE,ALU_TO_ADDR_LO),
 MOVE_ALU_TO_AREG1,
 MOVE_RAM_TO_PC_LO,
 ALU_TO(MODE_INC, CFLAG_VISIBLE,ALU_TO_ADDR_LO),
 MOVE_ALU_TO_SP,
 MOVE_RAM_TO_PC_HI,
 LOAD_PC,
 INC_PC,
 NEXTOP,
},

/* 20 - TAX */
{
 0x20,
 FETCH,
 MOVE_ACCU_TO_AREG1,
 ALU_TO_UPDFLAGS(ALU_TO_X, LOAD_ZVFLAGS_ALU | NEXTOP),
},

/* 21 - TXA */
{
 0x21,
 FETCH,
 MOVE_X_TO_AREG1,
 ALU_TO_UPDFLAGS(ALU_TO_ACCU, LOAD_ZVFLAGS_ALU | NEXTOP),
},

/* 22 - TAY */
{
 0x22,
 FETCH,
 MOVE_ACCU_TO_AREG1,
 ALU_TO_UPDFLAGS(ALU_TO_Y, LOAD_ZVFLAGS_ALU | NEXTOP),
},

/* 23 - TYA */
{
 0x23,
 FETCH,
 MOVE_Y_TO_AREG1,
 ALU_TO_UPDFLAGS(ALU_TO_ACCU, LOAD_ZVFLAGS_ALU | NEXTOP),
},

/* 24 - TXY */
{
 0x24,
 FETCH,
 MOVE_X_TO_AREG1,
 ALU_TO_UPDFLAGS(ALU_TO_Y, LOAD_ZVFLAGS_ALU | NEXTOP),
},

/* 25 - TYX */
{
 0x25,
 FETCH,
 MOVE_Y_TO_AREG1,
 ALU_TO_UPDFLAGS(ALU_TO_X, LOAD_ZVFLAGS_ALU | NEXTOP),
},

/* 26 - TSX */
{
 0x26,
 FETCH,
 MOVE_SP_TO_AREG1,
 ALU_TO_UPDFLAGS(ALU_TO_X, LOAD_ZVFLAGS_ALU | NEXTOP),
},

/* 27 - TXS */
{
 0x27,
 FETCH,
 MOVE_X_TO_AREG1,
 ALU_TO_UPDFLAGS(ALU_TO_SP, LOAD_ZVFLAGS_ALU | NEXTOP),
},

/* 28 - SAX */  /* swap ACCU with X-Reg */
{
 0x28,
 FETCH,
 MOVE_ACCU_TO_P,
 MOVE_X_TO_ACCU,
 MOVE_P_TO_X | NEXTOP,
},

/* 29 - SAY */  /* swap ACCU with Y-Reg */
{
 0x29,
 FETCH,
 MOVE_ACCU_TO_P,
 MOVE_Y_TO_ACCU,
 MOVE_P_TO_Y | NEXTOP,
},

/* 2A - SXY */  /* swap X-Reg with Y-Reg */
{
 0x2A,
 FETCH,
 MOVE_X_TO_P,
 MOVE_Y_TO_X,
 MOVE_P_TO_Y | NEXTOP,
},

/* 2B - RESERVED */
{
 0x2B,
 FETCH,
 NOP,
 NEXTOP,
},

/* 2C - CLA */  /* clear ACCU */
{
 0x2C,
 FETCH,
 CONST_00 | MOVE_CONST_TO_ACCU,
 CONST_02 | MOVE_CONST_TO_FLAGSR | LOAD_ZVFLAGS_REG | NEXTOP,
},



/* 2D - CLX */  /* clear X-Reg */
{
 0x2D,
 FETCH,
 CONST_00 | MOVE_CONST_TO_X,
 CONST_02 | MOVE_CONST_TO_FLAGSR | LOAD_ZVFLAGS_REG | NEXTOP,
},

/* 2E - CLY */  /* clear Y-Reg */
{
 0x2E,
 FETCH,
 CONST_00 | MOVE_CONST_TO_Y,
 CONST_02 | MOVE_CONST_TO_FLAGSR | LOAD_ZVFLAGS_REG | NEXTOP,
},

/* 2F - STZ abs */  /* store zero */
{
 0x2F,
 FETCH,
 NOP,
 MOVE_ROMPC_TO_ADDR_LO | INC_PC,
 NOP,
 MOVE_ROMPC_TO_ADDR_HI,
 INC_PC,
 CONST_00 | MOVE_CONST_TO_RAM,
 NEXTOP,
},

/* 30 - LDA # */
{
 0x30,
 FETCH,
 NOP,
 MOVE_ROMPC_TO_AREG1 | INC_PC,
 ALU_TO_UPDFLAGS(ALU_TO_ACCU, LOAD_ZVFLAGS_ALU | NEXTOP),
},

/* 31 - LDA ZP */
{
 0x31,
 FETCH,
 CONST_00 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ROMPC_TO_ADDR_LO,
 INC_PC,
 MOVE_RAM_TO_AREG1,
 ALU_TO_UPDFLAGS(ALU_TO_ACCU, LOAD_ZVFLAGS_ALU | NEXTOP),
},

/* 32 - LDA abs */
{
 0x32,
 ADRMODE_ABSOLUT,
 MOVE_RAM_TO_AREG1,
 ALU_TO_UPDFLAGS(ALU_TO_ACCU, LOAD_ZVFLAGS_ALU | NEXTOP),
},

/* 41 - STA ZP */
{
 0x41,
 FETCH,
 CONST_00 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ROMPC_TO_ADDR_LO,
 INC_PC,
 MOVE_ACCU_TO_RAM,
 NEXTOP,
},

/* 42 - STA abs */
{
 0x42,
 ADRMODE_ABSOLUT,
 MOVE_ACCU_TO_RAM,
 NEXTOP,
},

/* 50 - LDX # */
{
 0x50,
 FETCH,
 NOP,
 MOVE_ROMPC_TO_AREG1 | INC_PC,
 ALU_TO_UPDFLAGS(ALU_TO_X, LOAD_ZVFLAGS_ALU | NEXTOP),
},

/* 51 - LDX ZP */
{
 0x51,
 FETCH,
 CONST_00 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ROMPC_TO_ADDR_LO,
 INC_PC,
 MOVE_RAM_TO_AREG1,
 ALU_TO_UPDFLAGS(ALU_TO_X, LOAD_ZVFLAGS_ALU | NEXTOP),
},

/* 52 - LDX abs */
{
 0x52,
 ADRMODE_ABSOLUT,
 MOVE_RAM_TO_AREG1,
 ALU_TO_UPDFLAGS(ALU_TO_X, LOAD_ZVFLAGS_ALU | NEXTOP),
},

/* 54 - STX ZP */
{
 0x54,
 FETCH,
 CONST_00 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ROMPC_TO_ADDR_LO,
 INC_PC,
 MOVE_X_TO_RAM,
 NEXTOP,
},

/* 55 - STX abs */
{
 0x55,
 ADRMODE_ABSOLUT,
 MOVE_X_TO_RAM,
 NEXTOP,
},

/* 57 - LDY # */
{
 0x57,
 FETCH,
 NOP,
 MOVE_ROMPC_TO_AREG1 | INC_PC,
 ALU_TO_UPDFLAGS(ALU_TO_Y, LOAD_ZVFLAGS_ALU | NEXTOP),
},

/* 58 - LDY ZP */
{
 0x58,
 FETCH,
 CONST_00 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ROMPC_TO_ADDR_LO,
 INC_PC,
 MOVE_RAM_TO_AREG1,
 ALU_TO_UPDFLAGS(ALU_TO_Y, LOAD_ZVFLAGS_ALU | NEXTOP),
},

/* 59 - LDY abs */
{
 0x59,
 ADRMODE_ABSOLUT,
 MOVE_RAM_TO_AREG1,
 ALU_TO_UPDFLAGS(ALU_TO_Y, LOAD_ZVFLAGS_ALU | NEXTOP),
},

/* 5B - STY ZP */
{
 0x5B,
 FETCH,
 CONST_00 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ROMPC_TO_ADDR_LO,
 INC_PC,
 MOVE_Y_TO_RAM,
 NEXTOP,
},

/* 5C - STY abs */
{
 0x5C,
 ADRMODE_ABSOLUT,
 MOVE_Y_TO_RAM,
 NEXTOP,
},

/* 35 - LDA abs,X */
{
 0x35,
 ADRMODE_ABSOLUT_PLUS(REG_X),
 NOP,
 MOVE_RAM_TO_AREG1,
 ALU_TO_UPDFLAGS(ALU_TO_ACCU, LOAD_ZVFLAGS_ALU | NEXTOP),
},

/* 36 - LDA abs,Y */
{
 0x36,
 ADRMODE_ABSOLUT_PLUS(REG_Y),
 NOP,
 MOVE_RAM_TO_AREG1,
 ALU_TO_UPDFLAGS(ALU_TO_ACCU, LOAD_ZVFLAGS_ALU | NEXTOP),
},

/* 37 - LDAC abs,X */
{
 0x37,
 ADRMODE_ABSOLUT_PLUS(REG_X),
 NOP,
 MOVE_ROMAD_TO_AREG1,
 ALU_TO_UPDFLAGS(ALU_TO_ACCU, LOAD_ZVFLAGS_ALU | NEXTOP),
},

/* 38 - LDAC abs,Y */
{
 0x38,
 ADRMODE_ABSOLUT_PLUS(REG_Y),
 NOP,
 MOVE_ROMAD_TO_AREG1,
 ALU_TO_UPDFLAGS(ALU_TO_ACCU, LOAD_ZVFLAGS_ALU | NEXTOP),
},

/* 33 - LDA (ZP),X */
{
 0x33,
 ADRMODE_IND_ZP_PLUS(REG_X),
 NOP,
 MOVE_RAM_TO_AREG1,
 ALU_TO_UPDFLAGS(ALU_TO_ACCU, LOAD_ZVFLAGS_ALU | NEXTOP),
},

/* 34 - LDA (ZP),Y */
{
 0x34,
 ADRMODE_IND_ZP_PLUS(REG_Y),
 NOP,
 MOVE_RAM_TO_AREG1,
 ALU_TO_UPDFLAGS(ALU_TO_ACCU, LOAD_ZVFLAGS_ALU | NEXTOP),
},

/* 39 - LDAC (ZP),X */
{
 0x39,
 ADRMODE_IND_ZP_PLUS(REG_X),
 NOP,
 MOVE_ROMAD_TO_AREG1,
 ALU_TO_UPDFLAGS(ALU_TO_ACCU, LOAD_ZVFLAGS_ALU | NEXTOP),
},

/* 3A - LDAC (ZP),Y */
{
 0x3A,
 ADRMODE_IND_ZP_PLUS(REG_Y),
 NOP,
 MOVE_ROMAD_TO_AREG1,
 ALU_TO_UPDFLAGS(ALU_TO_ACCU, LOAD_ZVFLAGS_ALU | NEXTOP),
},

/* 43 - STA (ZP),X */
{
 0x43,
 ADRMODE_IND_ZP_PLUS(REG_X),
 NOP,
 MOVE_ACCU_TO_RAM,
 NEXTOP,
},

/* 44 - STA (ZP),Y */
{
 0x44,
 ADRMODE_IND_ZP_PLUS(REG_Y),
 NOP,
 MOVE_ACCU_TO_RAM,
 NEXTOP,
},

/* 45 - STA abs,X */
{
 0x45,
 ADRMODE_ABSOLUT_PLUS(REG_X),
 NOP,
 MOVE_ACCU_TO_RAM,
 NEXTOP,
},

/* 46 - STA abs,Y */
{
 0x46,
 ADRMODE_ABSOLUT_PLUS(REG_Y),
 NOP,
 MOVE_ACCU_TO_RAM,
 NEXTOP,
},

/* 53 - LDX abs,Y */
{
 0x53,
 ADRMODE_ABSOLUT_PLUS(REG_Y),
 NOP,
 MOVE_RAM_TO_AREG1,
 ALU_TO_UPDFLAGS(ALU_TO_X, LOAD_ZVFLAGS_ALU | NEXTOP),
},

/* 56 - STX abs,Y */
{
 0x56,
 ADRMODE_ABSOLUT_PLUS(REG_Y),
 NOP,
 MOVE_X_TO_RAM,
 NEXTOP,
},

/* 5A - LDY abs,X */
{
 0x5A,
 ADRMODE_ABSOLUT_PLUS(REG_X),
 NOP,
 MOVE_RAM_TO_AREG1,
 ALU_TO_UPDFLAGS(ALU_TO_Y, LOAD_ZVFLAGS_ALU | NEXTOP),
},

/* 5D - STY abs,X */
{
 0x5D,
 ADRMODE_ABSOLUT_PLUS(REG_X),
 NOP,
 MOVE_Y_TO_RAM,
 NEXTOP,
},

/* 47 - MOV ZP,ZP */
{
 0x47,
 FETCH,
 CONST_00 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ROMPC_TO_P | INC_PC,
 CONST_00 | MOVE_CONST_TO_AREG1,
 MOVE_ROMPC_TO_ADDR_LO,
 INC_PC,
 MOVE_RAM_TO_AREG2,
 MOVE_P_TO_ADDR_LO,
 ALU(MODE_OR,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM,
 NEXTOP,
},

/* 48 - MOV ZP,# */
{
 0x48,
 FETCH,
 NOP,
 MOVE_ROMPC_TO_ADDR_LO | INC_PC,
 CONST_00 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ROMPC_TO_P,
 INC_PC,
 MOVE_P_TO_RAM,
 NEXTOP,
},

/* 49 - DXJP */  /* dec X and jump if not zero */
{
 0x49,
 FETCH,
 MOVE_X_TO_AREG1,
 MOVE_ROMPC_TO_PC_LO | INC_PC,
 ALU_TO(MODE_DEC,CFLAG_VISIBLE,ALU_TO_X),
 MOVE_ROMPC_TO_PC_HI | INC_PC | LOAD_ZVFLAGS_ALU,
 DO_ON_ZFLAG( NOP , LOAD_PC ),   /* don't touch this line! */
 NEXTOP,  /* NEXTOP must be here! */
},

/* 4A - DYJP */  /* dec Y and jump if not zero */
{
 0x4A,
 FETCH,
 MOVE_Y_TO_AREG1,
 MOVE_ROMPC_TO_PC_LO | INC_PC,
 ALU_TO(MODE_DEC,CFLAG_VISIBLE,ALU_TO_Y),
 MOVE_ROMPC_TO_PC_HI | INC_PC | LOAD_ZVFLAGS_ALU,
 DO_ON_ZFLAG( NOP , LOAD_PC ),   /* don't touch this line! */
 NEXTOP,  /* NEXTOP must be here! */
},

/* 4B - LDA (ZP) */
{
 0x4B,
 FETCH,
 CONST_00 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ROMPC_TO_ADDR_LO,
 MOVE_ROMPC_TO_AREG1,
 INC_PC,
 MOVE_RAM_TO_P,
 ALU_TO(MODE_INC,CFLAG_VISIBLE,ALU_TO_ADDR_LO),
 NOP,
 MOVE_RAM_TO_ADDR_HI,
 MOVE_P_TO_ADDR_LO,
 NOP,
 MOVE_RAM_TO_AREG1,
 ALU_TO_UPDFLAGS(ALU_TO_ACCU, LOAD_ZVFLAGS_ALU | NEXTOP),
},

/* 40 - SWP */  /* swap ACCU lo/hi-nibble */
{
 0x40,
 FETCH,
 CONST_02 | MOVE_CONST_TO_AREG1,
 ALU_TO(MODE_SHL,CFLAG_VISIBLE,ALU_TO_AREG2),
 MOVE_ALU_TO_AREG1,
 ALU_TO(MODE_MULL,CFLAG_VISIBLE,ALU_TO_AREG2),
 MOVE_ACCU_TO_AREG1,
 ALU_TO(MODE_MULL,CFLAG_VISIBLE,ALU_TO_P),
 NOP,
 ALU_TO(MODE_DIV,CFLAG_VISIBLE,ALU_TO_AREG1),
 MOVE_P_TO_AREG2,
 ALU_TO(MODE_OR,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* 5E - BIT ZP,# */  /* BIT-Test with AND, affects Z,V-Flag */
{
 0x5E,
 FETCH,
 CONST_00 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ROMPC_TO_ADDR_LO,
 INC_PC,
 MOVE_RAM_TO_AREG1,
 NOP,
 MOVE_ROMPC_TO_AREG2 | INC_PC,
 ALU(MODE_AND,CFLAG_VISIBLE) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* 60 - CPX # */
{
 0x60,
 FETCH,
 MOVE_X_TO_AREG1,
 ALU(MODE_MULL,CFLAG_VISIBLE),
 MOVE_ROMPC_TO_AREG2 | INC_PC,
 ALU(MODE_SBC,CFLAG_ALU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* 61 - CPX ZP */
{
 0x61,
 FETCH,
 CONST_00 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ROMPC_TO_ADDR_LO | INC_PC,
 ALU(MODE_MULL,CFLAG_VISIBLE) | MOVE_X_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU(MODE_SBC,CFLAG_ALU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* 62 - CPX abs */
{
 0x62,
 FETCH,
 NOP,
 MOVE_ROMPC_TO_ADDR_LO | INC_PC,
 ALU(MODE_MULL,CFLAG_VISIBLE),
 MOVE_ROMPC_TO_ADDR_HI | INC_PC,
 MOVE_X_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU(MODE_SBC,CFLAG_ALU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* 63 - RESERVED */
{
 0x63,
 FETCH,
 NOP,
 NEXTOP,
},

/* 64 - CPY # */
{
 0x64,
 FETCH,
 MOVE_Y_TO_AREG1,
 ALU(MODE_MULL,CFLAG_VISIBLE),
 MOVE_ROMPC_TO_AREG2 | INC_PC,
 ALU(MODE_SBC,CFLAG_ALU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* 65 - CPY ZP */
{
 0x65,
 FETCH,
 CONST_00 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ROMPC_TO_ADDR_LO | INC_PC,
 ALU(MODE_MULL,CFLAG_VISIBLE) | MOVE_Y_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU(MODE_SBC,CFLAG_ALU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* 66 - CPY abs */
{
 0x66,
 FETCH,
 NOP,
 MOVE_ROMPC_TO_ADDR_LO | INC_PC,
 ALU(MODE_MULL,CFLAG_VISIBLE),
 MOVE_ROMPC_TO_ADDR_HI | INC_PC,
 MOVE_Y_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU(MODE_SBC,CFLAG_ALU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* 67 - RESERVED */
{
 0x67,
 FETCH,
 NOP,
 NEXTOP,
},

/* 68 - CAX */  /* compare ACCU with X */
{
 0x68,
 FETCH,
 MOVE_ACCU_TO_AREG1,
 ALU(MODE_MULL,CFLAG_VISIBLE),
 MOVE_X_TO_AREG2,
 ALU(MODE_SBC,CFLAG_ALU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* 69 - CAY */  /* compare ACCU with Y */
{
 0x69,
 FETCH,
 MOVE_ACCU_TO_AREG1,
 ALU(MODE_MULL,CFLAG_VISIBLE),
 MOVE_Y_TO_AREG2,
 ALU(MODE_SBC,CFLAG_ALU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* 6A - CXY */  /* compare X with Y */
{
 0x6A,
 FETCH,
 MOVE_X_TO_AREG1,
 ALU(MODE_MULL,CFLAG_VISIBLE),
 MOVE_Y_TO_AREG2,
 ALU(MODE_SBC,CFLAG_ALU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* 6B - INC */
{
 0x6B,
 FETCH,
 MOVE_ACCU_TO_AREG1,
 ALU_TO(MODE_INC,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* 70 - CMP # */
{
 0x70,
 FETCH,
 MOVE_ACCU_TO_AREG1,
 ALU(MODE_MULL,CFLAG_VISIBLE),
 MOVE_ROMPC_TO_AREG2 | INC_PC,
 ALU(MODE_SBC,CFLAG_ALU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* 71 - CMP ZP */
{
 0x71,
 FETCH,
 CONST_00 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ROMPC_TO_ADDR_LO | INC_PC,
 ALU(MODE_MULL,CFLAG_VISIBLE) | MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU(MODE_SBC,CFLAG_ALU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* 72 - CMP abs */
{
 0x72,
 FETCH,
 NOP,
 MOVE_ROMPC_TO_ADDR_LO | INC_PC,
 ALU(MODE_MULL,CFLAG_VISIBLE),
 MOVE_ROMPC_TO_ADDR_HI | INC_PC,
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU(MODE_SBC,CFLAG_ALU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* 73 - CMP (ZP),X */
{
 0x73,
 ADRMODE_IND_ZP_PLUS(REG_X),
 MOVE_ACCU_TO_AREG1,
 ALU(MODE_MULL,CFLAG_VISIBLE),
 MOVE_RAM_TO_AREG2,
 ALU(MODE_SBC,CFLAG_ALU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* 74 - CMP (ZP),Y */
{
 0x74,
 ADRMODE_IND_ZP_PLUS(REG_Y),
 MOVE_ACCU_TO_AREG1,
 ALU(MODE_MULL,CFLAG_VISIBLE),
 MOVE_RAM_TO_AREG2,
 ALU(MODE_SBC,CFLAG_ALU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* 75 - CMP abs,X */
{
 0x75,
 ADRMODE_ABSOLUT_PLUS(REG_X),
 MOVE_ACCU_TO_AREG1,
 ALU(MODE_MULL,CFLAG_VISIBLE),
 MOVE_RAM_TO_AREG2,
 ALU(MODE_SBC,CFLAG_ALU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* 76 - CMP abs,Y */
{
 0x76,
 ADRMODE_ABSOLUT_PLUS(REG_Y),
 MOVE_ACCU_TO_AREG1,
 ALU(MODE_MULL,CFLAG_VISIBLE),
 MOVE_RAM_TO_AREG2,
 ALU(MODE_SBC,CFLAG_ALU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* 77 - FREE FOR USER */
{
 0x77,
 FETCH,
 NOP,
 NEXTOP,
},

/* 78 - CMPC abs,X */
{
 0x78,
 ADRMODE_ABSOLUT_PLUS(REG_X),
 MOVE_ACCU_TO_AREG1,
 ALU(MODE_MULL,CFLAG_VISIBLE),
 MOVE_ROMAD_TO_AREG2,
 ALU(MODE_SBC,CFLAG_ALU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* 79 - CMPC abs,Y */
{
 0x79,
 ADRMODE_ABSOLUT_PLUS(REG_Y),
 MOVE_ACCU_TO_AREG1,
 ALU(MODE_MULL,CFLAG_VISIBLE),
 MOVE_ROMAD_TO_AREG2,
 ALU(MODE_SBC,CFLAG_ALU) | LOAD_FLAGS_ALU | NEXTOP,
},

/***************************************/


/* 80 - ADC # */
{
 0x80,
 FETCH,
 MOVE_ACCU_TO_AREG1,
 MOVE_ROMPC_TO_AREG2 | INC_PC,
 ALU_TO(MODE_ADC,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* 81 - ADC ZP */
{
 0x81,
 FETCH,
 CONST_00 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ROMPC_TO_ADDR_LO | INC_PC,
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_ADC,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* 82 - ADC abs */
{
 0x82,
 FETCH,
 NOP,
 MOVE_ROMPC_TO_ADDR_LO | INC_PC,
 MOVE_ACCU_TO_AREG1,
 MOVE_ROMPC_TO_ADDR_HI,
 INC_PC,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_ADC,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* 83 - ADC (ZP),X */
{
 0x83,
 ADRMODE_IND_ZP_PLUS(REG_X),
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_ADC,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* 84 - ADC (ZP),Y */
{
 0x84,
 ADRMODE_IND_ZP_PLUS(REG_Y),
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_ADC,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* 85 - ADC abs,X */
{
 0x85,
 ADRMODE_ABSOLUT_PLUS(REG_X),
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_ADC,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* 86 - ADC abs,Y */
{
 0x86,
 ADRMODE_ABSOLUT_PLUS(REG_Y),
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_ADC,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* 87 - FREE FOR USER */
{
 0x87,
 FETCH,
 NOP,
 NEXTOP,
},

/* 88 - ADCC abs,X */
{
 0x88,
 ADRMODE_ABSOLUT_PLUS(REG_X),
 MOVE_ACCU_TO_AREG1,
 MOVE_ROMAD_TO_AREG2,
 ALU_TO(MODE_ADC,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* 89 - ADCC abs,Y */
{
 0x89,
 ADRMODE_ABSOLUT_PLUS(REG_Y),
 MOVE_ACCU_TO_AREG1,
 MOVE_ROMAD_TO_AREG2,
 ALU_TO(MODE_ADC,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* 90 - SBC # */
{
 0x90,
 FETCH,
 MOVE_ACCU_TO_AREG1,
 MOVE_ROMPC_TO_AREG2 | INC_PC,
 ALU_TO(MODE_SBC,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* 91 - SBC ZP */
{
 0x91,
 FETCH,
 CONST_00 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ROMPC_TO_ADDR_LO | INC_PC,
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_SBC,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* 92 - SBC abs */
{
 0x92,
 FETCH,
 NOP,
 MOVE_ROMPC_TO_ADDR_LO | INC_PC,
 MOVE_ACCU_TO_AREG1,
 MOVE_ROMPC_TO_ADDR_HI,
 INC_PC,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_SBC,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* 93 - SBC (ZP),X */
{
 0x93,
 ADRMODE_IND_ZP_PLUS(REG_X),
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_SBC,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* 94 - SBC (ZP),Y */
{
 0x94,
 ADRMODE_IND_ZP_PLUS(REG_Y),
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_SBC,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* 95 - SBC abs,X */
{
 0x95,
 ADRMODE_ABSOLUT_PLUS(REG_X),
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_SBC,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* 96 - SBC abs,Y */
{
 0x96,
 ADRMODE_ABSOLUT_PLUS(REG_Y),
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_SBC,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* 97 - FREE FOR USER */
{
 0x97,
 FETCH,
 NOP,
 NEXTOP,
},

/* 98 - SBCC abs,X */
{
 0x98,
 ADRMODE_ABSOLUT_PLUS(REG_X),
 MOVE_ACCU_TO_AREG1,
 MOVE_ROMAD_TO_AREG2,
 ALU_TO(MODE_SBC,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* 99 - SBCC abs,Y */
{
 0x99,
 ADRMODE_ABSOLUT_PLUS(REG_Y),
 MOVE_ACCU_TO_AREG1,
 MOVE_ROMAD_TO_AREG2,
 ALU_TO(MODE_SBC,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* A0 - MUL # */
{
 0xA0,
 FETCH,
 MOVE_ACCU_TO_AREG1,
 MOVE_ROMPC_TO_AREG2 | INC_PC,
 DO_ON_CFLAG( ALU_TO(MODE_MULL,CFLAG_VISIBLE,ALU_TO_ACCU)        , ALU_TO(MODE_MULL,CFLAG_VISIBLE,ALU_TO_ACCU)|LOAD_ZVFLAGS_ALU|NEXTOP ),
 DO_ON_CFLAG( LOAD_ZVFLAGS_ALU                                   , NONE ),
 DO_ON_CFLAG( ALU_TO(MODE_MULH,CFLAG_VISIBLE,ALU_TO_X) | NEXTOP  , NONE ),
},

/* A1 - MUL ZP */
{
 0xA1,
 FETCH,
 CONST_00 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ROMPC_TO_ADDR_LO | INC_PC,
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 DO_ON_CFLAG( ALU_TO(MODE_MULL,CFLAG_VISIBLE,ALU_TO_ACCU)        , ALU_TO(MODE_MULL,CFLAG_VISIBLE,ALU_TO_ACCU)|LOAD_ZVFLAGS_ALU|NEXTOP ),
 DO_ON_CFLAG( LOAD_ZVFLAGS_ALU                                   , NONE ),
 DO_ON_CFLAG( ALU_TO(MODE_MULH,CFLAG_VISIBLE,ALU_TO_X) | NEXTOP  , NONE ),
},

/* A2 - MUL abs */
{
 0xA2,
 FETCH,
 NOP,
 MOVE_ROMPC_TO_ADDR_LO | INC_PC,
 MOVE_ACCU_TO_AREG1,
 MOVE_ROMPC_TO_ADDR_HI,
 INC_PC,
 MOVE_RAM_TO_AREG2,
 DO_ON_CFLAG( ALU_TO(MODE_MULL,CFLAG_VISIBLE,ALU_TO_ACCU)        , ALU_TO(MODE_MULL,CFLAG_VISIBLE,ALU_TO_ACCU)|LOAD_ZVFLAGS_ALU|NEXTOP ),
 DO_ON_CFLAG( LOAD_ZVFLAGS_ALU                                   , NONE ),
 DO_ON_CFLAG( ALU_TO(MODE_MULH,CFLAG_VISIBLE,ALU_TO_X) | NEXTOP  , NONE ),
},

/* A3 - MUL (ZP),X */
{
 0xA3,
 ADRMODE_IND_ZP_PLUS(REG_X),
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 DO_ON_CFLAG( ALU_TO(MODE_MULL,CFLAG_VISIBLE,ALU_TO_ACCU)        , ALU_TO(MODE_MULL,CFLAG_VISIBLE,ALU_TO_ACCU)|LOAD_ZVFLAGS_ALU|NEXTOP ),
 DO_ON_CFLAG( LOAD_ZVFLAGS_ALU                                   , NONE ),
 DO_ON_CFLAG( ALU_TO(MODE_MULH,CFLAG_VISIBLE,ALU_TO_X) | NEXTOP  , NONE ),
},

/* A4 - MUL (ZP),Y */
{
 0xA4,
 ADRMODE_IND_ZP_PLUS(REG_Y),
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 DO_ON_CFLAG( ALU_TO(MODE_MULL,CFLAG_VISIBLE,ALU_TO_ACCU)        , ALU_TO(MODE_MULL,CFLAG_VISIBLE,ALU_TO_ACCU)|LOAD_ZVFLAGS_ALU|NEXTOP ),
 DO_ON_CFLAG( LOAD_ZVFLAGS_ALU                                   , NONE ),
 DO_ON_CFLAG( ALU_TO(MODE_MULH,CFLAG_VISIBLE,ALU_TO_X) | NEXTOP  , NONE ),
},

/* A5 - MUL abs,X */
{
 0xA5,
 ADRMODE_ABSOLUT_PLUS(REG_X),
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 DO_ON_CFLAG( ALU_TO(MODE_MULL,CFLAG_VISIBLE,ALU_TO_ACCU)        , ALU_TO(MODE_MULL,CFLAG_VISIBLE,ALU_TO_ACCU)|LOAD_ZVFLAGS_ALU|NEXTOP ),
 DO_ON_CFLAG( LOAD_ZVFLAGS_ALU                                   , NONE ),
 DO_ON_CFLAG( ALU_TO(MODE_MULH,CFLAG_VISIBLE,ALU_TO_X) | NEXTOP  , NONE ),
},

/* A6 - MUL abs,Y */
{
 0xA6,
 ADRMODE_ABSOLUT_PLUS(REG_Y),
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 DO_ON_CFLAG( ALU_TO(MODE_MULL,CFLAG_VISIBLE,ALU_TO_ACCU)        , ALU_TO(MODE_MULL,CFLAG_VISIBLE,ALU_TO_ACCU)|LOAD_ZVFLAGS_ALU|NEXTOP ),
 DO_ON_CFLAG( LOAD_ZVFLAGS_ALU                                   , NONE ),
 DO_ON_CFLAG( ALU_TO(MODE_MULH,CFLAG_VISIBLE,ALU_TO_X) | NEXTOP  , NONE ),
},

/* A7 - FREE FOR USER */
{
 0xA7,
 FETCH,
 NOP,
 NEXTOP,
},

/* A8 - MULC abs,X */
{
 0xA8,
 ADRMODE_ABSOLUT_PLUS(REG_X),
 MOVE_ACCU_TO_AREG1,
 MOVE_ROMAD_TO_AREG2,
 DO_ON_CFLAG( ALU_TO(MODE_MULL,CFLAG_VISIBLE,ALU_TO_ACCU)        , ALU_TO(MODE_MULL,CFLAG_VISIBLE,ALU_TO_ACCU)|LOAD_ZVFLAGS_ALU|NEXTOP ),
 DO_ON_CFLAG( LOAD_ZVFLAGS_ALU                                   , NONE ),
 DO_ON_CFLAG( ALU_TO(MODE_MULH,CFLAG_VISIBLE,ALU_TO_X) | NEXTOP  , NONE ),
},

/* A9 - MULC abs,Y */
{
 0xA9,
 ADRMODE_ABSOLUT_PLUS(REG_Y),
 MOVE_ACCU_TO_AREG1,
 MOVE_ROMAD_TO_AREG2,
 DO_ON_CFLAG( ALU_TO(MODE_MULL,CFLAG_VISIBLE,ALU_TO_ACCU)        , ALU_TO(MODE_MULL,CFLAG_VISIBLE,ALU_TO_ACCU)|LOAD_ZVFLAGS_ALU|NEXTOP ),
 DO_ON_CFLAG( LOAD_ZVFLAGS_ALU                                   , NONE ),
 DO_ON_CFLAG( ALU_TO(MODE_MULH,CFLAG_VISIBLE,ALU_TO_X) | NEXTOP  , NONE ),
},

/* B0 - DIV # */
{
 0xB0,
 FETCH,
 MOVE_ACCU_TO_AREG1,
 MOVE_ROMPC_TO_AREG2 | INC_PC,
 ALU_TO(MODE_DIV,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* B1 - DIV ZP */
{
 0xB1,
 FETCH,
 CONST_00 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ROMPC_TO_ADDR_LO | INC_PC,
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_DIV,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* B2 - DIV abs */
{
 0xB2,
 FETCH,
 NOP,
 MOVE_ROMPC_TO_ADDR_LO | INC_PC,
 MOVE_ACCU_TO_AREG1,
 MOVE_ROMPC_TO_ADDR_HI,
 INC_PC,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_DIV,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* B3 - DIV (ZP),X */
{
 0xB3,
 ADRMODE_IND_ZP_PLUS(REG_X),
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_DIV,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* B4 - DIV (ZP),Y */
{
 0xB4,
 ADRMODE_IND_ZP_PLUS(REG_Y),
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_DIV,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* B5 - DIV abs,X */
{
 0xB5,
 ADRMODE_ABSOLUT_PLUS(REG_X),
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_DIV,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* B6 - DIV abs,Y */
{
 0xB6,
 ADRMODE_ABSOLUT_PLUS(REG_Y),
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_DIV,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* B7 - FREE FOR USER */
{
 0xB7,
 FETCH,
 NOP,
 NEXTOP,
},

/* B8 - DIVC abs,X */
{
 0xB8,
 ADRMODE_ABSOLUT_PLUS(REG_X),
 MOVE_ACCU_TO_AREG1,
 MOVE_ROMAD_TO_AREG2,
 ALU_TO(MODE_DIV,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* B9 - DIVC abs,Y */
{
 0xB9,
 ADRMODE_ABSOLUT_PLUS(REG_Y),
 MOVE_ACCU_TO_AREG1,
 MOVE_ROMAD_TO_AREG2,
 ALU_TO(MODE_DIV,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* C0 - MOD # */
{
 0xC0,
 FETCH,
 MOVE_ACCU_TO_AREG1,
 MOVE_ROMPC_TO_AREG2,
 ALU(MODE_DIV,CFLAG_VISIBLE) | INC_PC,
 MOVE_ALU_TO_AREG1,
 ALU_TO(MODE_MULL,CFLAG_VISIBLE,ALU_TO_AREG2),
 MOVE_ACCU_TO_AREG1,
 ALU_TO(MODE_SBC,CFLAG_ALU,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* C1 - MOD ZP */
{
 0xC1,
 FETCH,
 CONST_00 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ROMPC_TO_ADDR_LO,
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU(MODE_DIV,CFLAG_VISIBLE) | INC_PC,
 MOVE_ALU_TO_AREG1,
 ALU_TO(MODE_MULL,CFLAG_VISIBLE,ALU_TO_AREG2),
 MOVE_ACCU_TO_AREG1,
 ALU_TO(MODE_SBC,CFLAG_ALU,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* C2 - MOD abs */
{
 0xC2,
 FETCH,
 NOP,
 MOVE_ROMPC_TO_ADDR_LO | INC_PC,
 MOVE_ACCU_TO_AREG1,
 MOVE_ROMPC_TO_ADDR_HI,
 INC_PC,
 MOVE_RAM_TO_AREG2,
 ALU(MODE_DIV,CFLAG_VISIBLE),
 MOVE_ALU_TO_AREG1,
 ALU_TO(MODE_MULL,CFLAG_VISIBLE,ALU_TO_AREG2),
 MOVE_ACCU_TO_AREG1,
 ALU_TO(MODE_SBC,CFLAG_ALU,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* C3 - MOD (ZP),X */
{
 0xC3,
 ADRMODE_IND_ZP_PLUS(REG_X),
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU(MODE_DIV,CFLAG_VISIBLE),
 MOVE_ALU_TO_AREG1,
 ALU_TO(MODE_MULL,CFLAG_VISIBLE,ALU_TO_AREG2),
 MOVE_ACCU_TO_AREG1,
 ALU_TO(MODE_SBC,CFLAG_ALU,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* C4 - MOD (ZP),Y */
{
 0xC4,
 ADRMODE_IND_ZP_PLUS(REG_Y),
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU(MODE_DIV,CFLAG_VISIBLE),
 MOVE_ALU_TO_AREG1,
 ALU_TO(MODE_MULL,CFLAG_VISIBLE,ALU_TO_AREG2),
 MOVE_ACCU_TO_AREG1,
 ALU_TO(MODE_SBC,CFLAG_ALU,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* C5 - MOD abs,X */
{
 0xC5,
 ADRMODE_ABSOLUT_PLUS(REG_X),
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU(MODE_DIV,CFLAG_VISIBLE),
 MOVE_ALU_TO_AREG1,
 ALU_TO(MODE_MULL,CFLAG_VISIBLE,ALU_TO_AREG2),
 MOVE_ACCU_TO_AREG1,
 ALU_TO(MODE_SBC,CFLAG_ALU,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* C6 - MOD abs,Y */
{
 0xC6,
 ADRMODE_ABSOLUT_PLUS(REG_Y),
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU(MODE_DIV,CFLAG_VISIBLE),
 MOVE_ALU_TO_AREG1,
 ALU_TO(MODE_MULL,CFLAG_VISIBLE,ALU_TO_AREG2),
 MOVE_ACCU_TO_AREG1,
 ALU_TO(MODE_SBC,CFLAG_ALU,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* C7 - FREE FOR USER */
{
 0xC7,
 FETCH,
 NOP,
 NEXTOP,
},

/* C8 - MODC abs,X */
{
 0xC8,
 ADRMODE_ABSOLUT_PLUS(REG_X),
 MOVE_ACCU_TO_AREG1,
 MOVE_ROMAD_TO_AREG2,
 ALU(MODE_DIV,CFLAG_VISIBLE),
 MOVE_ALU_TO_AREG1,
 ALU_TO(MODE_MULL,CFLAG_VISIBLE,ALU_TO_AREG2),
 MOVE_ACCU_TO_AREG1,
 ALU_TO(MODE_SBC,CFLAG_ALU,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* C9 - MODC abs,Y */
{
 0xC9,
 ADRMODE_ABSOLUT_PLUS(REG_Y),
 MOVE_ACCU_TO_AREG1,
 MOVE_ROMAD_TO_AREG2,
 ALU(MODE_DIV,CFLAG_VISIBLE),
 MOVE_ALU_TO_AREG1,
 ALU_TO(MODE_MULL,CFLAG_VISIBLE,ALU_TO_AREG2),
 MOVE_ACCU_TO_AREG1,
 ALU_TO(MODE_SBC,CFLAG_ALU,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* D0 - AND # */
{
 0xD0,
 FETCH,
 MOVE_ACCU_TO_AREG1,
 MOVE_ROMPC_TO_AREG2 | INC_PC,
 ALU_TO(MODE_AND,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* D1 - AND ZP */
{
 0xD1,
 FETCH,
 CONST_00 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ROMPC_TO_ADDR_LO | INC_PC,
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_AND,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* D2 - AND abs */
{
 0xD2,
 FETCH,
 NOP,
 MOVE_ROMPC_TO_ADDR_LO | INC_PC,
 MOVE_ACCU_TO_AREG1,
 MOVE_ROMPC_TO_ADDR_HI,
 INC_PC,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_AND,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* D3 - AND (ZP),X */
{
 0xD3,
 ADRMODE_IND_ZP_PLUS(REG_X),
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_AND,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* D4 - AND (ZP),Y */
{
 0xD4,
 ADRMODE_IND_ZP_PLUS(REG_Y),
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_AND,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* D5 - AND abs,X */
{
 0xD5,
 ADRMODE_ABSOLUT_PLUS(REG_X),
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_AND,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* D6 - AND abs,Y */
{
 0xD6,
 ADRMODE_ABSOLUT_PLUS(REG_Y),
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_AND,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* D7 - FREE FOR USER */
{
 0xD7,
 FETCH,
 NOP,
 NEXTOP,
},

/* D8 - ANDC abs,X */
{
 0xD8,
 ADRMODE_ABSOLUT_PLUS(REG_X),
 MOVE_ACCU_TO_AREG1,
 MOVE_ROMAD_TO_AREG2,
 ALU_TO(MODE_AND,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* D9 - ANDC abs,Y */
{
 0xD9,
 ADRMODE_ABSOLUT_PLUS(REG_Y),
 MOVE_ACCU_TO_AREG1,
 MOVE_ROMAD_TO_AREG2,
 ALU_TO(MODE_AND,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* E0 - ORA # */
{
 0xE0,
 FETCH,
 MOVE_ACCU_TO_AREG1,
 MOVE_ROMPC_TO_AREG2 | INC_PC,
 ALU_TO(MODE_OR,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* E1 - ORA ZP */
{
 0xE1,
 FETCH,
 CONST_00 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ROMPC_TO_ADDR_LO | INC_PC,
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_OR,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* E2 - ORA abs */
{
 0xE2,
 FETCH,
 NOP,
 MOVE_ROMPC_TO_ADDR_LO | INC_PC,
 MOVE_ACCU_TO_AREG1,
 MOVE_ROMPC_TO_ADDR_HI,
 INC_PC,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_OR,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* E3 - ORA (ZP),X */
{
 0xE3,
 ADRMODE_IND_ZP_PLUS(REG_X),
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_OR,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* E4 - ORA (ZP),Y */
{
 0xE4,
 ADRMODE_IND_ZP_PLUS(REG_Y),
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_OR,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* E5 - ORA abs,X */
{
 0xE5,
 ADRMODE_ABSOLUT_PLUS(REG_X),
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_OR,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* E6 - ORA abs,Y */
{
 0xE6,
 ADRMODE_ABSOLUT_PLUS(REG_Y),
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_OR,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* E7 - FREE FOR USER */
{
 0xE7,
 FETCH,
 NOP,
 NEXTOP,
},

/* E8 - ORAC abs,X */
{
 0xE8,
 ADRMODE_ABSOLUT_PLUS(REG_X),
 MOVE_ACCU_TO_AREG1,
 MOVE_ROMAD_TO_AREG2,
 ALU_TO(MODE_OR,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* E9 - ORAC abs,Y */
{
 0xE9,
 ADRMODE_ABSOLUT_PLUS(REG_Y),
 MOVE_ACCU_TO_AREG1,
 MOVE_ROMAD_TO_AREG2,
 ALU_TO(MODE_OR,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* F0 - EOR # */
{
 0xF0,
 FETCH,
 MOVE_ACCU_TO_AREG1,
 MOVE_ROMPC_TO_AREG2 | INC_PC,
 ALU_TO(MODE_XOR,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* F1 - EOR ZP */
{
 0xF1,
 FETCH,
 CONST_00 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ROMPC_TO_ADDR_LO | INC_PC,
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_XOR,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* F2 - EOR abs */
{
 0xF2,
 FETCH,
 NOP,
 MOVE_ROMPC_TO_ADDR_LO | INC_PC,
 MOVE_ACCU_TO_AREG1,
 MOVE_ROMPC_TO_ADDR_HI,
 INC_PC,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_XOR,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* F3 - EOR (ZP),X */
{
 0xF3,
 ADRMODE_IND_ZP_PLUS(REG_X),
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_XOR,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* F4 - EOR (ZP),Y */
{
 0xF4,
 ADRMODE_IND_ZP_PLUS(REG_Y),
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_XOR,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* F5 - EOR abs,X */
{
 0xF5,
 ADRMODE_ABSOLUT_PLUS(REG_X),
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_XOR,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* F6 - EOR abs,Y */
{
 0xF6,
 ADRMODE_ABSOLUT_PLUS(REG_Y),
 MOVE_ACCU_TO_AREG1,
 MOVE_RAM_TO_AREG2,
 ALU_TO(MODE_XOR,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* F7 - FREE FOR USER */
{
 0xF7,
 FETCH,
 NOP,
 NEXTOP,
},

/* F8 - EORC abs,X */
{
 0xF8,
 ADRMODE_ABSOLUT_PLUS(REG_X),
 MOVE_ACCU_TO_AREG1,
 MOVE_ROMAD_TO_AREG2,
 ALU_TO(MODE_XOR,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* F9 - EORC abs,Y */
{
 0xF9,
 ADRMODE_ABSOLUT_PLUS(REG_Y),
 MOVE_ACCU_TO_AREG1,
 MOVE_ROMAD_TO_AREG2,
 ALU_TO(MODE_XOR,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* 7B - INX */
{
 0x7B,
 FETCH,
 MOVE_X_TO_AREG1,
 ALU_TO(MODE_INC,CFLAG_VISIBLE,ALU_TO_X) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* 8B - INY */
{
 0x8B,
 FETCH,
 MOVE_Y_TO_AREG1,
 ALU_TO(MODE_INC,CFLAG_VISIBLE,ALU_TO_Y) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* 9B - DEC */
{
 0x9B,
 FETCH,
 MOVE_ACCU_TO_AREG1,
 ALU_TO(MODE_DEC,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* AB - DEX */
{
 0xAB,
 FETCH,
 MOVE_X_TO_AREG1,
 ALU_TO(MODE_DEC,CFLAG_VISIBLE,ALU_TO_X) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* BB - DEY */
{
 0xBB,
 FETCH,
 MOVE_Y_TO_AREG1,
 ALU_TO(MODE_DEC,CFLAG_VISIBLE,ALU_TO_Y) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* CB - SHL */
{
 0xCB,
 FETCH,
 MOVE_ACCU_TO_AREG1,
 ALU_TO(MODE_SHL,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* DB - SHR */
{
 0xDB,
 FETCH,
 MOVE_ACCU_TO_AREG1,
 ALU_TO(MODE_SHR,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* EB - ROL */
{
 0xEB,
 FETCH,
 MOVE_ACCU_TO_AREG1,
 ALU_TO(MODE_ROL,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* FB - ROR */
{
 0xFB,
 FETCH,
 MOVE_ACCU_TO_AREG1,
 ALU_TO(MODE_ROR,CFLAG_VISIBLE,ALU_TO_ACCU) | LOAD_FLAGS_ALU | NEXTOP,
},

/* 7C - INC ZP */
{
 0x7C,
 FETCH,
 CONST_00 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ROMPC_TO_ADDR_LO,
 INC_PC,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_INC,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_ZVFLAGS_ALU,
 NEXTOP,
},

/* 7D - INC abs */
{
 0x7D,
 ADRMODE_ABSOLUT,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_INC,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_ZVFLAGS_ALU,
 NEXTOP,
},

/* 7E - INC abs,X */
{
 0x7E,
 ADRMODE_ABSOLUT_PLUS(REG_X),
 NOP,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_INC,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_ZVFLAGS_ALU,
 NEXTOP,
},

/* 7F - INC abs,Y */
{
 0x7F,
 ADRMODE_ABSOLUT_PLUS(REG_Y),
 NOP,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_INC,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_ZVFLAGS_ALU,
 NEXTOP,
},

/* 8C - DEC ZP */
{
 0x8C,
 FETCH,
 CONST_00 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ROMPC_TO_ADDR_LO,
 INC_PC,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_DEC,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_ZVFLAGS_ALU,
 NEXTOP,
},

/* 8D - DEC abs */
{
 0x8D,
 ADRMODE_ABSOLUT,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_DEC,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_ZVFLAGS_ALU,
 NEXTOP,
},

/* 8E - DEC abs,X */
{
 0x8E,
 ADRMODE_ABSOLUT_PLUS(REG_X),
 NOP,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_DEC,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_ZVFLAGS_ALU,
 NEXTOP,
},

/* 8F - DEC abs,Y */
{
 0x8F,
 ADRMODE_ABSOLUT_PLUS(REG_Y),
 NOP,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_DEC,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_ZVFLAGS_ALU,
 NEXTOP,
},

/* 9C - INC (ZP),X */
{
 0x9C,
 ADRMODE_IND_ZP_PLUS(REG_X),
 NOP,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_INC,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_ZVFLAGS_ALU,
 NEXTOP,
},

/* 9D - INC (ZP),Y */
{
 0x9D,
 ADRMODE_IND_ZP_PLUS(REG_Y),
 NOP,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_INC,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_ZVFLAGS_ALU,
 NEXTOP,
},

/* 9E - DEC (ZP),X */
{
 0x9E,
 ADRMODE_IND_ZP_PLUS(REG_X),
 NOP,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_DEC,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_ZVFLAGS_ALU,
 NEXTOP,
},

/* 9F - DEC (ZP),Y */
{
 0x9F,
 ADRMODE_IND_ZP_PLUS(REG_Y),
 NOP,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_DEC,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_ZVFLAGS_ALU,
 NEXTOP,
},

/* AC - SHL ZP */
{
 0xAC,
 FETCH,
 CONST_00 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ROMPC_TO_ADDR_LO,
 INC_PC,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_SHL,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_FLAGS_ALU,
 NEXTOP,
},

/* AD - SHL abs */
{
 0xAD,
 ADRMODE_ABSOLUT,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_SHL,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_FLAGS_ALU,
 NEXTOP,
},

/* AE - SHL abs,X */
{
 0xAE,
 ADRMODE_ABSOLUT_PLUS(REG_X),
 NOP,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_SHL,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_FLAGS_ALU,
 NEXTOP,
},

/* AF - SHL abs,Y */
{
 0xAF,
 ADRMODE_ABSOLUT_PLUS(REG_Y),
 NOP,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_SHL,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_FLAGS_ALU,
 NEXTOP,
},

/* BC - SHR ZP */
{
 0xBC,
 FETCH,
 CONST_00 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ROMPC_TO_ADDR_LO,
 INC_PC,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_SHR,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_FLAGS_ALU,
 NEXTOP,
},

/* BD - SHR abs */
{
 0xBD,
 ADRMODE_ABSOLUT,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_SHR,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_FLAGS_ALU,
 NEXTOP,
},

/* BE - SHR abs,X */
{
 0xBE,
 ADRMODE_ABSOLUT_PLUS(REG_X),
 NOP,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_SHR,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_FLAGS_ALU,
 NEXTOP,
},

/* BF - SHR abs,Y */
{
 0xBF,
 ADRMODE_ABSOLUT_PLUS(REG_Y),
 NOP,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_SHR,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_FLAGS_ALU,
 NEXTOP,
},

/* CC - SHL (ZP),X */
{
 0xCC,
 ADRMODE_IND_ZP_PLUS(REG_X),
 NOP,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_SHL,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_FLAGS_ALU,
 NEXTOP,
},

/* CD - SHL (ZP),Y */
{
 0xCD,
 ADRMODE_IND_ZP_PLUS(REG_Y),
 NOP,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_SHL,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_FLAGS_ALU,
 NEXTOP,
},

/* CE - SHR (ZP),X */
{
 0xCE,
 ADRMODE_IND_ZP_PLUS(REG_X),
 NOP,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_SHR,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_FLAGS_ALU,
 NEXTOP,
},

/* CF - SHR (ZP),Y */
{
 0xCF,
 ADRMODE_IND_ZP_PLUS(REG_Y),
 NOP,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_SHR,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_FLAGS_ALU,
 NEXTOP,
},

/* DC - ROL ZP */
{
 0xDC,
 FETCH,
 CONST_00 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ROMPC_TO_ADDR_LO,
 INC_PC,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_ROL,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_FLAGS_ALU,
 NEXTOP,
},

/* DD - ROL abs */
{
 0xDD,
 ADRMODE_ABSOLUT,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_ROL,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_FLAGS_ALU,
 NEXTOP,
},

/* DE - ROL abs,X */
{
 0xDE,
 ADRMODE_ABSOLUT_PLUS(REG_X),
 NOP,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_ROL,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_FLAGS_ALU,
 NEXTOP,
},

/* DF - ROL abs,Y */
{
 0xDF,
 ADRMODE_ABSOLUT_PLUS(REG_Y),
 NOP,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_ROL,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_FLAGS_ALU,
 NEXTOP,
},

/* EC - ROR ZP */
{
 0xEC,
 FETCH,
 CONST_00 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ROMPC_TO_ADDR_LO,
 INC_PC,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_ROR,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_FLAGS_ALU,
 NEXTOP,
},

/* ED - ROR abs */
{
 0xED,
 ADRMODE_ABSOLUT,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_ROR,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_FLAGS_ALU,
 NEXTOP,
},

/* EE - ROR abs,X */
{
 0xEE,
 ADRMODE_ABSOLUT_PLUS(REG_X),
 NOP,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_ROR,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_FLAGS_ALU,
 NEXTOP,
},

/* EF - ROR abs,Y */
{
 0xEF,
 ADRMODE_ABSOLUT_PLUS(REG_Y),
 NOP,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_ROR,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_FLAGS_ALU,
 NEXTOP,
},

/* FC - ROL (ZP),X */
{
 0xFC,
 ADRMODE_IND_ZP_PLUS(REG_X),
 NOP,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_ROL,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_FLAGS_ALU,
 NEXTOP,
},

/* FD - ROL (ZP),Y */
{
 0xFD,
 ADRMODE_IND_ZP_PLUS(REG_Y),
 NOP,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_ROL,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_FLAGS_ALU,
 NEXTOP,
},

/* FE - ROR (ZP),X */
{
 0xFE,
 ADRMODE_IND_ZP_PLUS(REG_X),
 NOP,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_ROR,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_FLAGS_ALU,
 NEXTOP,
},

/* FF - ROR (ZP),Y */
{
 0xFF,
 ADRMODE_IND_ZP_PLUS(REG_Y),
 NOP,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_ROR,CFLAG_VISIBLE),
 MOVE_ALU_TO_RAM | LOAD_FLAGS_ALU,
 NEXTOP,
},

/* 3E - SBK */  /* set bank register */
{
 0x3E,
 FETCH,
 CONST_00 | MOVE_CONST_TO_ADDR_LO,
 MOVE_ROMPC_TO_ADDR_HI,
 INC_PC,
 MOVE_RAM_TO_AREG1,
 CONST_00 | MOVE_CONST_TO_AREG2,
 MOVE_ROMPC_TO_P,
 ALU(MODE_OR,CFLAG_VISIBLE),
 MOVE_P_TO_RAM,
 MOVE_SP_TO_ADDR_LO,
 CONST_01 | MOVE_CONST_TO_ADDR_HI,
 MOVE_SP_TO_AREG1 | INC_PC,
 MOVE_ALU_TO_RAM,
 ALU_TO(MODE_DEC, CFLAG_VISIBLE, ALU_TO_SP) | NEXTOP,
},

/* 3F - RBK */  /* restore bank register */
{
 0x3F,
 FETCH,
 MOVE_SP_TO_AREG1,
 ALU_TO(MODE_INC, CFLAG_VISIBLE, ALU_TO_ADDR_LO),
 CONST_01 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ALU_TO_SP,
 MOVE_RAM_TO_P,
 CONST_00 | MOVE_CONST_TO_ADDR_LO,
 MOVE_ROMPC_TO_ADDR_HI,
 INC_PC,
 MOVE_P_TO_RAM,
 NEXTOP,
},

/* BA - PUSH # */  /* push single byte */
{
 0xBA,
 FETCH,
 MOVE_SP_TO_ADDR_LO,
 MOVE_ROMPC_TO_P,
 CONST_01 | MOVE_CONST_TO_ADDR_HI,
 MOVE_SP_TO_AREG1 | INC_PC,
 MOVE_P_TO_RAM,
 ALU_TO(MODE_DEC, CFLAG_VISIBLE, ALU_TO_SP) | NEXTOP,
},

/* CA - PUSA # */  /* push address (16 bit value, push high-byte first) */
{
 0xCA,
 FETCH,
 CONST_01 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ROMPC_TO_AREG2 | INC_PC,
 MOVE_SP_TO_ADDR_LO,
 MOVE_ROMPC_TO_P | INC_PC,
 MOVE_SP_TO_AREG1,
 MOVE_P_TO_RAM,
 ALU_TO(MODE_DEC, CFLAG_VISIBLE, ALU_TO_ADDR_LO),
 MOVE_ALU_TO_SP,
 CONST_00 | MOVE_CONST_TO_AREG1,
 ALU(MODE_OR,CFLAG_VISIBLE) | MOVE_SP_TO_AREG1,
 MOVE_ALU_TO_RAM,
 ALU_TO(MODE_DEC, CFLAG_VISIBLE, ALU_TO_SP) | NEXTOP,
},

/* 9A - PUSH ZP */
{
 0x9A,
 FETCH,
 CONST_00 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ROMPC_TO_ADDR_LO,
 INC_PC,
 MOVE_RAM_TO_P,
 MOVE_SP_TO_ADDR_LO,
 CONST_01 | MOVE_CONST_TO_ADDR_HI,
 MOVE_SP_TO_AREG1,
 MOVE_P_TO_RAM,
 ALU_TO(MODE_DEC,CFLAG_VISIBLE,ALU_TO_SP) | NEXTOP,
},

/* AA - POP ZP */
{
 0xAA,
 FETCH,
 MOVE_SP_TO_AREG1,
 ALU_TO(MODE_INC, CFLAG_VISIBLE, ALU_TO_ADDR_LO),
 CONST_01 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ALU_TO_SP,
 MOVE_RAM_TO_P,
 CONST_00 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ROMPC_TO_ADDR_LO,
 INC_PC,
 MOVE_P_TO_RAM,
 NEXTOP,
},

/* 1D - RTB */ /* Return from Break -Interrupt */
{
 0x1D,
 FETCH,
 CONST_01 | MOVE_CONST_TO_ADDR_HI,
 MOVE_SP_TO_AREG1,
 ALU_TO(MODE_INC, CFLAG_VISIBLE,ALU_TO_ADDR_LO),
 MOVE_ALU_TO_AREG1,
 MOVE_RAM_TO_PC_LO,
 ALU_TO(MODE_INC, CFLAG_VISIBLE,ALU_TO_ADDR_LO),
 MOVE_ALU_TO_AREG1,
 MOVE_RAM_TO_PC_HI,
 ALU_TO(MODE_INC, CFLAG_VISIBLE,ALU_TO_ADDR_LO),
 MOVE_ALU_TO_SP | LOAD_PC,
 MOVE_RAM_TO_FLAGSR,
 LOAD_FLAGS_REG | NEXTOP,
},

/* 3B - DLY */ /* delay with Y register */
{
 0x3B,
 FETCH,
 MOVE_Y_TO_AREG1,
 ALU_TO(MODE_DEC,CFLAG_VISIBLE,ALU_TO_Y),
 MOVE_PC_LO_TO_AREG1 | LOAD_ZVFLAGS_ALU,
 ALU_TO(MODE_DEC,CFLAG_VISIBLE,ALU_TO_PC_LO),
 MOVE_PC_HI_TO_AREG1,
 ALU_TO(MODE_CDEC,CFLAG_ALU,ALU_TO_PC_HI),
 DO_ON_ZFLAG( NOP , LOAD_PC ),
 NEXTOP,
},

/* 3C - FLG ZP */ /* set Z,V-flags according to value in ZP */
{
 0x3C,
 FETCH,
 CONST_00 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ROMPC_TO_ADDR_LO,
 INC_PC,
 MOVE_RAM_TO_AREG1,
 ALU(MODE_MULH,CFLAG_VISIBLE) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* 3D - FLS ZP */ /* set Z,V-flags according to value in ZP, V flag is set through bit6 */
{
 0x3D,
 FETCH,
 CONST_00 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ROMPC_TO_ADDR_LO,
 INC_PC,
 MOVE_RAM_TO_AREG1,
 ALU_TO(MODE_SHL,CFLAG_VISIBLE,ALU_TO_AREG2),
 NOP,
 ALU_TO(MODE_SHR,CFLAG_VISIBLE,ALU_TO_AREG1),
 ALU_TO(MODE_SHR,CFLAG_VISIBLE,ALU_TO_AREG1),
 ALU_TO(MODE_SHR,CFLAG_VISIBLE,ALU_TO_AREG1),
 ALU_TO(MODE_SHR,CFLAG_VISIBLE,ALU_TO_AREG1),
 ALU_TO(MODE_SHR,CFLAG_VISIBLE,ALU_TO_AREG1),
 ALU_TO(MODE_SHR,CFLAG_VISIBLE,ALU_TO_AREG1),
 ALU_TO(MODE_SHR,CFLAG_VISIBLE,ALU_TO_AREG1),
 NOP,
 ALU(MODE_OR,CFLAG_VISIBLE) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* DA - INS # */ /* increment stackpointer by value */
{
 0xDA,
 FETCH,
 MOVE_SP_TO_AREG1,
 MOVE_ROMPC_TO_AREG2 | INC_PC,
 CONST_00 | MOVE_CONST_TO_FLAGSR,
 ALU_TO(MODE_ADC,CFLAG_REGISTER,ALU_TO_SP) | NEXTOP,
},

/* 6C - LPT # */ /* load 16bit-ptr in X and Y, X=lo, Y=hi */
{
 0x6C,
 FETCH,
 NOP,
 MOVE_ROMPC_TO_X | INC_PC,
 NOP,
 MOVE_ROMPC_TO_Y | INC_PC,
 NEXTOP,
},

/* 4D - SKA */ /* skip next byte */
{
 0x4D,
 FETCH,
 INC_PC,
 NEXTOP,
},

/* 4E - SKB */ /* skip next two bytes */
{
 0x4E,
 FETCH,
 INC_PC,
 INC_PC,
 NEXTOP,
},

/* 4F - SKC */ /* skip next three bytes */
{
 0x4F,
 FETCH,
 INC_PC,
 INC_PC,
 INC_PC,
 NEXTOP,
},

/* EA - LPA */ /* load accu from RAM addressed by XY -pointer, and auto-increment ptr */
{
 0xEA,
 FETCH,
 MOVE_X_TO_ADDR_LO,
 MOVE_Y_TO_ADDR_HI,
 MOVE_X_TO_AREG1,
 MOVE_RAM_TO_ACCU,
 ALU_TO(MODE_INCC,CFLAG_VISIBLE,ALU_TO_X),
 MOVE_Y_TO_AREG1,
 ALU_TO(MODE_CINC,CFLAG_ALU,ALU_TO_Y),
 MOVE_ACCU_TO_AREG1,
 ALU(MODE_MULH,CFLAG_VISIBLE) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* FA - SPA */ /* store accu to RAM addressed by XY -pointer, and auto-increment ptr */
{
 0xFA,
 FETCH,
 MOVE_X_TO_ADDR_LO,
 MOVE_Y_TO_ADDR_HI,
 MOVE_X_TO_AREG1,
 MOVE_ACCU_TO_RAM,
 ALU_TO(MODE_INCC,CFLAG_VISIBLE,ALU_TO_X),
 MOVE_Y_TO_AREG1,
 ALU_TO(MODE_CINC,CFLAG_ALU,ALU_TO_Y) | NEXTOP,
},

/* 1C - TSTC abs,X */  /* BIT-Test: Accu AND table, affects Z,V-Flag, but accu remains unchanged */
{
 0x1C,
 ADRMODE_ABSOLUT_PLUS(REG_X),
 MOVE_ACCU_TO_AREG1,
 MOVE_ROMAD_TO_AREG2,
 ALU(MODE_AND,CFLAG_VISIBLE) | LOAD_ZVFLAGS_ALU | NEXTOP,
},

/* 4C - LDCC abs,X */  /* does the following:  STA temp / LDAC abs,X / LDX temp */
{
 0x4C,
 ADRMODE_ABSOLUT_PLUS(REG_X),
 MOVE_ACCU_TO_P,
 MOVE_ROMAD_TO_ACCU,
 MOVE_P_TO_X | NEXTOP,
},

/* 6D - LPT abs */  /* load 16bit-ptr into XY. source is adressed by abs adr */
{
 0x6D,
 FETCH,
 NOP,
 MOVE_ROMPC_TO_P | INC_PC,
 MOVE_P_TO_ADDR_LO,
 MOVE_P_TO_AREG1,
 MOVE_ROMPC_TO_P,
 MOVE_P_TO_ADDR_HI,
 ALU(MODE_INCC,CFLAG_VISIBLE) | MOVE_P_TO_AREG1,
 MOVE_RAM_TO_X,
 MOVE_ALU_TO_ADDR_LO,
 ALU_TO(MODE_CINC,CFLAG_ALU,ALU_TO_ADDR_HI),
 INC_PC,
 MOVE_RAM_TO_Y,
 NEXTOP,
},

/* 6E - SPT abs */  /* store 16bit-ptr (XY) to abs.address (X) and abs.address+1 (Y) */
{
 0x6E,
 FETCH,
 NOP,
 MOVE_ROMPC_TO_P | INC_PC,
 MOVE_P_TO_ADDR_LO,
 MOVE_P_TO_AREG1,
 MOVE_ROMPC_TO_P,
 MOVE_P_TO_ADDR_HI,
 ALU(MODE_INCC,CFLAG_VISIBLE) | MOVE_P_TO_AREG1,
 MOVE_X_TO_RAM,
 MOVE_ALU_TO_ADDR_LO,
 ALU_TO(MODE_CINC,CFLAG_ALU,ALU_TO_ADDR_HI),
 INC_PC,
 MOVE_Y_TO_RAM,
 NEXTOP,
},

/* 5F - LPT ZP */  /* load 16bit-ptr into XY. source is adressed by ZP adr */
{
 0x5F,
 FETCH,
 CONST_00 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ROMPC_TO_P,
 MOVE_P_TO_ADDR_LO,
 MOVE_P_TO_AREG1,
 MOVE_RAM_TO_X,
 ALU_TO(MODE_INC,CFLAG_VISIBLE,ALU_TO_ADDR_LO),
 INC_PC,
 MOVE_RAM_TO_Y,
 NEXTOP,
},

/* 6F - SPT ZP */  /* store 16bit-ptr (XY) to ZP address (X) and ZP address+1 (Y) */
{
 0x6F,
 FETCH,
 CONST_00 | MOVE_CONST_TO_ADDR_HI,
 MOVE_ROMPC_TO_P,
 MOVE_P_TO_ADDR_LO,
 MOVE_P_TO_AREG1,
 MOVE_X_TO_RAM,
 ALU_TO(MODE_INC,CFLAG_VISIBLE,ALU_TO_ADDR_LO),
 INC_PC,
 MOVE_Y_TO_RAM,
 NEXTOP,
},

};
