#include <stdio.h>
#include <stdlib.h>

int main(int argc, char *argv[])
{
  FILE *f;
  int i = 1, c;

  if (argc < 2)
  {
    printf("\nConverts binary files to hexadecimal lines. The hex numbers are\n");
    printf("printed to the console. Syntax:\n");
    printf("  %s file1 [file2] [file n] > outputfile.hex\n\n", argv[0]);
    printf("To create the romimg.hex file for MyCPU simulation, enter:\n");
    printf("  %s ic15.bin ic14.bin > romimg.hex\n\n", argv[0]);
    return 1;
  }

  for (; i < argc; i++)
  {
    f = fopen(argv[i], "rb");
    if (!f)
    {
      fprintf(stderr, "Failed to open file %s. Stop.\n", argv[i]);
      return 1;
    }
    while (!feof(f))
    {
      c = fgetc(f);
      if (c < 0)
        break;
      printf("%02X \n", c & 0xFF);
    }
    fclose(f);
  }

  return 0;
}
