quit -sim
set TOP ../..
set SRCPATH_FPGA        $TOP/FPGA
set SRCPATH_CPLD        $TOP/CPLD
set TESTBENCH_PATH      $TOP/simulation
file delete -force work
vlib work
vmap work  work/

# compile testbench
vcom -work work $TESTBENCH_PATH/mycpu_tb.vhd

# compile sources
vcom -work work $SRCPATH_CPLD/cpld_top.vhd
vcom -work work $SRCPATH_FPGA/cpu_alu.vhd
vcom -work work $SRCPATH_FPGA/cpu_busif.vhd
vcom -work work $SRCPATH_FPGA/cpu_clk.vhd
vcom -work work $SRCPATH_FPGA/cpu_mcode_simu.vhd
vcom -work work $SRCPATH_FPGA/cpu_pc.vhd
vcom -work work $SRCPATH_FPGA/cpu_reg.vhd
vcom -work work $SRCPATH_FPGA/cpu_top.vhd
vcom -work work $SRCPATH_FPGA/cpu_uctrl.vhd
vcom -work work $SRCPATH_FPGA/comp_intctrl.vhd
vcom -work work $SRCPATH_FPGA/comp_memunit.vhd
vcom -work work $SRCPATH_FPGA/comp_mio.vhd
vcom -work work $SRCPATH_FPGA/comp_ide.vhd
vcom -work work $SRCPATH_FPGA/comp_flashprog.vhd
vcom -work work $SRCPATH_FPGA/ramblocks.vhd
vcom -work work $SRCPATH_FPGA/mycpusys.vhd
vcom -work work $SRCPATH_FPGA/UART/slib_clock_div.vhd
vcom -work work $SRCPATH_FPGA/UART/slib_counter.vhd
vcom -work work $SRCPATH_FPGA/UART/slib_edge_detect.vhd
vcom -work work $SRCPATH_FPGA/UART/slib_fifo.vhd
vcom -work work $SRCPATH_FPGA/UART/slib_input_filter.vhd
vcom -work work $SRCPATH_FPGA/UART/slib_input_sync.vhd
vcom -work work $SRCPATH_FPGA/UART/slib_mv_filter.vhd
vcom -work work $SRCPATH_FPGA/UART/uart_16750.vhd
vcom -work work $SRCPATH_FPGA/UART/uart_baudgen.vhd
vcom -work work $SRCPATH_FPGA/UART/uart_interrupt.vhd
vcom -work work $SRCPATH_FPGA/UART/uart_receiver.vhd
vcom -work work $SRCPATH_FPGA/UART/uart_transmitter.vhd
vcom -work work $SRCPATH_FPGA/unisim/unisim_VPKG.vhd
vcom -work work $SRCPATH_FPGA/unisim/RAMB16_S9.vhd

# start simulation
vsim verification_mycpu

view objects
#view wave

do mycpu_wave.do

#run 5 us
