-------------------------------------------------------------------------------
--
--  Copyright (c) 2010, Dennis Kuschel, www.mycpu.eu
--  All rights reserved. 
--
--  Redistribution and use in source and binary forms, with or without
--  modification, are permitted provided that the following conditions
--  are met:
--
--   1. Redistributions of source code must retain the above copyright
--      notice, this list of conditions and the following disclaimer.
--   2. Redistributions in binary form must reproduce the above copyright
--      notice, this list of conditions and the following disclaimer in the
--      documentation and/or other materials provided with the distribution.
--   3. The name of the author may not be used to endorse or promote
--      products derived from this software without specific prior written
--      permission. 
--
--  THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
--  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
--  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
--  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
--  INDIRECT,  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
--  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
--  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
--  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
--  STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
--  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
--  OF THE POSSIBILITY OF SUCH DAMAGE.
--
-------------------------------------------------------------------------------
--
--  Part of MyCPU processor:  Register
--

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;


entity registers is
    port (
        res       : IN  std_logic;   -- FPGA reset
        clk       : IN  std_logic;
        busclk_i  : IN  std_logic;
        const     : IN  std_logic_vector(1 downto 0);
        clocks_i  : IN  std_logic_vector(3 downto 0);
        enables_i : IN  std_logic_vector(3 downto 0);
        data_i    : IN  std_logic_vector(7 downto 0);
        data_o    : OUT std_logic_vector(7 downto 0);
        dovalid_o : OUT std_logic  -- '1' means data_o carries valid data
    );
end registers;


architecture rtl of registers is

    signal reg_a    : std_logic_vector(7 downto 0); -- accumulator
    signal reg_x    : std_logic_vector(7 downto 0); -- X-register
    signal reg_y    : std_logic_vector(7 downto 0); -- Y-register
    signal reg_p    : std_logic_vector(7 downto 0); -- temp.register
    signal reg_sp   : std_logic_vector(7 downto 0); -- stack pointer

begin

    -- register write access
    regwr:
    process (clk, res)
    begin
        if res = '1' then
            reg_sp <= (others => '0');
            reg_a  <= (others => '0');
            reg_x  <= (others => '0');
            reg_y  <= (others => '0');
            reg_p  <= (others => '0');
        elsif rising_edge(clk) then
            if busclk_i = '1' then
                case clocks_i is
                    when "1000" =>  reg_sp<= data_i;
                    when "1001" =>  reg_a <= data_i;
                    when "1010" =>  reg_x <= data_i;
                    when "1011" =>  reg_y <= data_i;
                    when "1100" =>  reg_p <= data_i;
                    when others =>
                end case;
            end if;
        end if;
    end process;

    -- register read access
    regrd:
    process (enables_i, const, reg_sp, reg_a, reg_x, reg_y, reg_p)
    begin
        dovalid_o <= '1';
        case enables_i is
            when "1000" =>  data_o <= reg_sp;
            when "1001" =>  data_o <= reg_a;
            when "1010" =>  data_o <= reg_x;
            when "1011" =>  data_o <= reg_y;
            when "1100" =>  data_o <= reg_p;
            when "0101" =>  data_o <= "000000" & const;
            when others =>  data_o <= (others => '0');
                            dovalid_o <= '0';
        end case;
    end process;

end rtl;
