--
-- Emulation of MyCPU micro-code EPROMs IC1, IC2 and IC3
--
-- This file was automatically generated from the ICx.bin EPROM image files.
--
-- WHEN's that are written in capital letters are "don't cares"
--

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;

entity ucode is
	port (
		opcode_i     : IN  std_logic_vector(7 downto 0);
		mctr_i       : IN  std_logic_vector(4 downto 0);
		irq_i        : IN  std_logic;
		cflag_i      : IN  std_logic;
		zflag_i      : IN  std_logic;
		vflag_i      : IN  std_logic;
		clocks_o     : OUT std_logic_vector(3 downto 0);
		enable_o     : OUT std_logic_vector(3 downto 0);
		alu_mode_o   : OUT std_logic_vector(3 downto 0);
		alu_fsel_o   : OUT std_logic;
		alu_csel_o   : OUT std_logic;
		n_alu_ldfc_o : OUT std_logic;
		n_alu_ldvz_o : OUT std_logic;
		const_01_o   : OUT std_logic;
		const_02_o   : OUT std_logic;
		intern_o     : OUT std_logic;
		n_loadpc_o   : OUT std_logic;
		adrsel_o     : OUT std_logic;
		n_aluclk_o   : OUT std_logic;
		n_incpc_o    : OUT std_logic;
		n_mend_o     : OUT std_logic
	);
end ucode;

architecture rtl of ucode is
begin

	opdecode:
	process (opcode_i,irq_i,cflag_i,zflag_i,vflag_i,mctr_i)
	begin

		-- default output values
		clocks_o     <= "0000";
		enable_o     <= "0000";
		alu_mode_o   <= "0000";
		alu_fsel_o   <= '0';
		alu_csel_o   <= '0';
		n_alu_ldfc_o <= '1';
		n_alu_ldvz_o <= '1';
		const_01_o   <= '0';
		const_02_o   <= '0';
		intern_o     <= '0';
		n_loadpc_o   <= '1';
		adrsel_o     <= '1';
		n_aluclk_o   <= '1';
		n_incpc_o    <= '1';
		n_mend_o     <= '1';

		if irq_i = '1' then

			-- microcode for interrupt execution
			case mctr_i is
				when "00000" =>
					clocks_o     <= "0001";
					enable_o     <= "0001";
					n_incpc_o    <= '0';
				when "00001" =>
					clocks_o     <= "0110";
					enable_o     <= "0110";
				when "00010" =>
					clocks_o     <= "0011";
					enable_o     <= "0101";
					const_01_o   <= '1';
				when "00011" =>
					clocks_o     <= "0010";
					enable_o     <= "1000";
				when "00100" =>
					clocks_o     <= "1110";
					enable_o     <= "1000";
					alu_mode_o   <= "1111";
					intern_o     <= '1';
					adrsel_o     <= '0';
				when "00101" =>
					clocks_o     <= "0111";
					enable_o     <= "1110";
					alu_mode_o   <= "1111";
					adrsel_o     <= '0';
				when "00110" =>
					clocks_o     <= "0010";
					enable_o     <= "1111";
					alu_mode_o   <= "1111";
					n_aluclk_o   <= '0';
				when "00111" =>
					clocks_o     <= "1110";
					enable_o     <= "1101";
					alu_mode_o   <= "1111";
				when "01000" =>
					clocks_o     <= "1000";
					enable_o     <= "1111";
					alu_mode_o   <= "1111";
					n_aluclk_o   <= '0';
				when "01001" =>
					clocks_o     <= "1110";
					enable_o     <= "0011";
					alu_mode_o   <= "1111";
				when "01010" =>
					clocks_o     <= "1100";
					enable_o     <= "1111";
					alu_mode_o   <= "1111";
					n_aluclk_o   <= '0';
				when "01011" =>
					clocks_o     <= "1110";
					enable_o     <= "0100";
					alu_mode_o   <= "1001";
					alu_csel_o   <= '1';
				when "01100" =>
					clocks_o     <= "0100";
					enable_o     <= "0101";
					alu_mode_o   <= "1001";
					alu_csel_o   <= '1';
					const_01_o   <= '1';
					const_02_o   <= '1';
					intern_o     <= '1';
					adrsel_o     <= '0';
					n_aluclk_o   <= '0';
				when "01101" =>
					clocks_o     <= "0111";
					enable_o     <= "1101";
					adrsel_o     <= '0';
				when "01110" =>
					clocks_o     <= "0010";
					enable_o     <= "1000";
				when "01111" =>
					clocks_o     <= "0101";
					enable_o     <= "0101";
					intern_o     <= '1';
					adrsel_o     <= '0';
				when "10000" =>
					clocks_o     <= "0111";
					enable_o     <= "1100";
					alu_mode_o   <= "1111";
					adrsel_o     <= '0';
				when "10001" =>
					clocks_o     <= "1110";
					enable_o     <= "1000";
					alu_mode_o   <= "1111";
					n_loadpc_o   <= '0';
					n_incpc_o    <= '0';
					n_mend_o     <= '0';
				when "10010" =>
					clocks_o     <= "1000";
					enable_o     <= "1111";
					alu_mode_o   <= "1111";
					intern_o     <= '1';
					n_aluclk_o   <= '0';
				WHEN "10011" =>
					clocks_o     <= "0010";
					enable_o     <= "1000";
				WHEN "10100" =>
					clocks_o     <= "1110";
					enable_o     <= "1000";
					alu_mode_o   <= "1111";
					intern_o     <= '1';
					adrsel_o     <= '0';
				WHEN "10101" =>
					clocks_o     <= "0111";
					enable_o     <= "1110";
					alu_mode_o   <= "1111";
					adrsel_o     <= '0';
				WHEN "10110" =>
					clocks_o     <= "0010";
					enable_o     <= "1111";
					alu_mode_o   <= "1111";
					n_aluclk_o   <= '0';
				WHEN "10111" =>
					clocks_o     <= "1110";
					enable_o     <= "1101";
					alu_mode_o   <= "1111";
				WHEN "11000" =>
					clocks_o     <= "1000";
					enable_o     <= "1111";
					alu_mode_o   <= "1111";
					n_aluclk_o   <= '0';
				WHEN "11001" =>
					clocks_o     <= "1110";
					enable_o     <= "0011";
					alu_mode_o   <= "1111";
				WHEN "11010" =>
					clocks_o     <= "1100";
					enable_o     <= "1111";
					alu_mode_o   <= "1111";
					n_aluclk_o   <= '0';
				WHEN "11011" =>
					clocks_o     <= "1110";
					enable_o     <= "0100";
					alu_mode_o   <= "1001";
					alu_csel_o   <= '1';
				WHEN "11100" =>
					clocks_o     <= "0100";
					enable_o     <= "0101";
					alu_mode_o   <= "1001";
					alu_csel_o   <= '1';
					const_01_o   <= '1';
					const_02_o   <= '1';
					intern_o     <= '1';
					adrsel_o     <= '0';
					n_aluclk_o   <= '0';
				WHEN "11101" =>
					clocks_o     <= "0111";
					enable_o     <= "1101";
					adrsel_o     <= '0';
				WHEN "11110" =>
					clocks_o     <= "0010";
					enable_o     <= "1000";
				WHEN "11111" =>
					clocks_o     <= "0101";
					enable_o     <= "0101";
					intern_o     <= '1';
					adrsel_o     <= '0';
				WHEN others =>
			end case;
		else

			-- microcode for every OP-code
			case opcode_i is

				when x"00" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
						when "00011" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
						when "00100" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "0111";
							enable_o     <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
						when "01000" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "0111";
							enable_o     <= "0100";
							adrsel_o     <= '0';
						when "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
						when "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
						when "01100" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01101" =>
							clocks_o     <= "0111";
							enable_o     <= "0011";
							alu_mode_o   <= "1010";
							adrsel_o     <= '0';
						when "01110" =>
							clocks_o     <= "1110";
							enable_o     <= "0101";
							alu_mode_o   <= "1010";
							const_01_o   <= '1';
							const_02_o   <= '1';
						when "01111" =>
							clocks_o     <= "0100";
							enable_o     <= "1111";
							alu_mode_o   <= "1010";
							n_aluclk_o   <= '0';
						when "10000" =>
							clocks_o     <= "0101";
							enable_o     <= "0101";
						when "10001" =>
							n_loadpc_o   <= '0';
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						when "10010" =>
							intern_o     <= '1';
						WHEN "10011" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
						WHEN "10100" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "0111";
							enable_o     <= "1110";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
						WHEN "11000" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "11001" =>
							clocks_o     <= "0111";
							enable_o     <= "0100";
							adrsel_o     <= '0';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
						WHEN "11011" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
						WHEN "11100" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "0111";
							enable_o     <= "0011";
							alu_mode_o   <= "1010";
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "1110";
							enable_o     <= "0101";
							alu_mode_o   <= "1010";
							const_01_o   <= '1';
							const_02_o   <= '1';
						WHEN "11111" =>
							clocks_o     <= "0100";
							enable_o     <= "1111";
							alu_mode_o   <= "1010";
							n_aluclk_o   <= '0';
						WHEN others =>
					end case;

				when x"01" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							n_mend_o     <= '0';
						when "00010" =>
							intern_o     <= '1';
						WHEN "00011" =>
							n_mend_o     <= '0';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							n_mend_o     <= '0';
						WHEN "00110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							n_mend_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							n_mend_o     <= '0';
						WHEN "01010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							n_mend_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							n_mend_o     <= '0';
						WHEN "01110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							n_mend_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							n_mend_o     <= '0';
						WHEN "10010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							n_mend_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							n_mend_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							n_mend_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							n_mend_o     <= '0';
						WHEN "11010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							n_mend_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							n_mend_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							n_mend_o     <= '0';
						WHEN others =>
					end case;

				when x"02" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0110";
							enable_o     <= "0110";
							n_mend_o     <= '0';
						when "00010" =>
							intern_o     <= '1';
						WHEN "00011" =>
							clocks_o     <= "0110";
							enable_o     <= "0110";
							n_mend_o     <= '0';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							clocks_o     <= "0110";
							enable_o     <= "0110";
							n_mend_o     <= '0';
						WHEN "00110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							clocks_o     <= "0110";
							enable_o     <= "0110";
							n_mend_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "0110";
							enable_o     <= "0110";
							n_mend_o     <= '0';
						WHEN "01010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							clocks_o     <= "0110";
							enable_o     <= "0110";
							n_mend_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "0110";
							enable_o     <= "0110";
							n_mend_o     <= '0';
						WHEN "01110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							clocks_o     <= "0110";
							enable_o     <= "0110";
							n_mend_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0110";
							enable_o     <= "0110";
							n_mend_o     <= '0';
						WHEN "10010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0110";
							enable_o     <= "0110";
							n_mend_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "0110";
							enable_o     <= "0110";
							n_mend_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							clocks_o     <= "0110";
							enable_o     <= "0110";
							n_mend_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0110";
							enable_o     <= "0110";
							n_mend_o     <= '0';
						WHEN "11010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "0110";
							enable_o     <= "0110";
							n_mend_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "0110";
							enable_o     <= "0110";
							n_mend_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							clocks_o     <= "0110";
							enable_o     <= "0110";
							n_mend_o     <= '0';
						WHEN others =>
					end case;

				when x"03" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							n_mend_o     <= '0';
						when "00010" =>
							intern_o     <= '1';
						WHEN "00011" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							n_mend_o     <= '0';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							n_mend_o     <= '0';
						WHEN "00110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							n_mend_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							n_mend_o     <= '0';
						WHEN "01010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							n_mend_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							n_mend_o     <= '0';
						WHEN "01110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							n_mend_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							n_mend_o     <= '0';
						WHEN "10010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							n_mend_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							n_mend_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							n_mend_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							n_mend_o     <= '0';
						WHEN "11010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							n_mend_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							n_mend_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							n_mend_o     <= '0';
						WHEN others =>
					end case;

				when x"04" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							n_mend_o     <= '0';
						when "00010" =>
							n_alu_ldfc_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00011" =>
							n_mend_o     <= '0';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							n_mend_o     <= '0';
						WHEN "00110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							n_mend_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							n_mend_o     <= '0';
						WHEN "01010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							n_mend_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							n_mend_o     <= '0';
						WHEN "01110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							n_mend_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							n_mend_o     <= '0';
						WHEN "10010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							n_mend_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							n_mend_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							n_mend_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							n_mend_o     <= '0';
						WHEN "11010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							n_mend_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							n_mend_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							n_mend_o     <= '0';
						WHEN others =>
					end case;

				when x"05" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							alu_mode_o   <= "0101";
							n_mend_o     <= '0';
						when "00010" =>
							alu_mode_o   <= "0101";
							n_alu_ldfc_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00011" =>
							alu_mode_o   <= "0101";
							n_mend_o     <= '0';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							alu_mode_o   <= "0101";
							n_mend_o     <= '0';
						WHEN "00110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							alu_mode_o   <= "0101";
							n_mend_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							alu_mode_o   <= "0101";
							n_mend_o     <= '0';
						WHEN "01010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							alu_mode_o   <= "0101";
							n_mend_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							alu_mode_o   <= "0101";
							n_mend_o     <= '0';
						WHEN "01110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							alu_mode_o   <= "0101";
							n_mend_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							alu_mode_o   <= "0101";
							n_mend_o     <= '0';
						WHEN "10010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							alu_mode_o   <= "0101";
							n_mend_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							alu_mode_o   <= "0101";
							n_mend_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							alu_mode_o   <= "0101";
							n_mend_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							alu_mode_o   <= "0101";
							n_mend_o     <= '0';
						WHEN "11010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							alu_mode_o   <= "0101";
							n_mend_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							alu_mode_o   <= "0101";
							n_mend_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							alu_mode_o   <= "0101";
							n_mend_o     <= '0';
						WHEN others =>
					end case;

				when x"06" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							if zflag_i = '0' then
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1110";
								alu_mode_o   <= "0010";
								alu_fsel_o   <= '1';
							end if;
						when "00010" =>
							if zflag_i = '0' then
								intern_o     <= '1';
							else
								clocks_o     <= "1111";
								enable_o     <= "0101";
								alu_mode_o   <= "0010";
								alu_fsel_o   <= '1';
								const_02_o   <= '1';
								n_mend_o     <= '0';
							end if;
						when "00011" =>
							if zflag_i = '0' then
								intern_o     <= '1';
							else
								enable_o     <= "1111";
								alu_mode_o   <= "0010";
								alu_fsel_o   <= '1';
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							if zflag_i = '0' then
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1110";
								alu_mode_o   <= "0010";
								alu_fsel_o   <= '1';
							end if;
						WHEN others =>
					end case;

				when x"07" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							if zflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1110";
								alu_mode_o   <= "0001";
								alu_fsel_o   <= '1';
							else
								n_mend_o     <= '0';
							end if;
						when "00010" =>
							if zflag_i = '0' then
								clocks_o     <= "1111";
								enable_o     <= "0101";
								alu_mode_o   <= "0001";
								alu_fsel_o   <= '1';
								const_02_o   <= '1';
								n_mend_o     <= '0';
							else
								intern_o     <= '1';
							end if;
						when "00011" =>
							if zflag_i = '0' then
								enable_o     <= "1111";
								alu_mode_o   <= "0001";
								alu_fsel_o   <= '1';
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								intern_o     <= '1';
							end if;
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							if zflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1110";
								alu_mode_o   <= "0001";
								alu_fsel_o   <= '1';
							else
								n_mend_o     <= '0';
							end if;
						WHEN others =>
					end case;

				when x"08" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						when "00010" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						when "00011" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00100" =>
							clocks_o     <= "0111";
							enable_o     <= "1001";
							alu_mode_o   <= "1111";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "00101" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						WHEN "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						WHEN "10010" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "10011" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						WHEN "11010" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "11011" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"09" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						when "00010" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						when "00011" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00100" =>
							clocks_o     <= "0111";
							enable_o     <= "1010";
							alu_mode_o   <= "1111";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "00101" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						WHEN "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						WHEN "10010" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "10011" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						WHEN "11010" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "11011" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"0A" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						when "00010" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						when "00011" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00100" =>
							clocks_o     <= "0111";
							enable_o     <= "1011";
							alu_mode_o   <= "1111";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "00101" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						WHEN "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						WHEN "10010" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "10011" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						WHEN "11010" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "11011" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"0B" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						when "00010" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						when "00011" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00100" =>
							clocks_o     <= "0111";
							enable_o     <= "1110";
							alu_mode_o   <= "1111";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "00101" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						WHEN "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						WHEN "10010" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "10011" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						WHEN "11010" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "11011" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"0C" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00011" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						when "00100" =>
							if cflag_i = '0' then
								clocks_o     <= "1000";
								enable_o     <= "1101";
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
							else
								clocks_o     <= "1000";
								enable_o     <= "1101";
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
							end if;
						when "00101" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "0010";
								alu_mode_o   <= "1000";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "0010";
								alu_mode_o   <= "1001";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							end if;
						when "00110" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "00111" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "01011" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10011" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11011" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN others =>
					end case;

				when x"0D" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00011" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						when "00100" =>
							if cflag_i = '0' then
								clocks_o     <= "1000";
								enable_o     <= "1101";
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
							else
								clocks_o     <= "1000";
								enable_o     <= "1101";
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
							end if;
						when "00101" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "0010";
								alu_mode_o   <= "1000";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "0010";
								alu_mode_o   <= "1001";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							end if;
						when "00110" =>
							if cflag_i = '0' then
								clocks_o     <= "1010";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1010";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "00111" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "01011" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10011" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11011" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN others =>
					end case;

				when x"0E" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00011" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						when "00100" =>
							if cflag_i = '0' then
								clocks_o     <= "1000";
								enable_o     <= "1101";
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
							else
								clocks_o     <= "1000";
								enable_o     <= "1101";
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
							end if;
						when "00101" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "0010";
								alu_mode_o   <= "1000";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "0010";
								alu_mode_o   <= "1001";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							end if;
						when "00110" =>
							if cflag_i = '0' then
								clocks_o     <= "1011";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1011";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "00111" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "01011" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10011" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11011" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN others =>
					end case;

				when x"0F" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00011" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						when "00100" =>
							clocks_o     <= "1000";
							enable_o     <= "1101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							enable_o     <= "0010";
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
							n_mend_o     <= '0';
						when "00110" =>
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "00111" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "01011" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10011" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11011" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN others =>
					end case;

				when x"10" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							intern_o     <= '1';
						when "00100" =>
							clocks_o     <= "0101";
							enable_o     <= "0001";
						when "00101" =>
							n_loadpc_o   <= '0';
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						when "00110" =>
							intern_o     <= '1';
						WHEN "00111" =>
							intern_o     <= '1';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							intern_o     <= '1';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							intern_o     <= '1';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							intern_o     <= '1';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							intern_o     <= '1';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							intern_o     <= '1';
						WHEN others =>
					end case;

				when x"11" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
							intern_o     <= '1';
						when "00100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0100";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00111" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01001" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01010" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01011" =>
							clocks_o     <= "0101";
							enable_o     <= "0010";
							adrsel_o     <= '0';
						when "01100" =>
							n_loadpc_o   <= '0';
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						when "01101" =>
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0100";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "01111" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
							intern_o     <= '1';
						WHEN "10100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0100";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10111" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
							intern_o     <= '1';
						WHEN "11100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0100";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "11111" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN others =>
					end case;

				when x"12" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "0100";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
						when "01001" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							const_01_o   <= '1';
							n_aluclk_o   <= '0';
						when "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01100" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01101" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01110" =>
							clocks_o     <= "0101";
							enable_o     <= "0010";
							adrsel_o     <= '0';
						when "01111" =>
							n_loadpc_o   <= '0';
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						when "10000" =>
							intern_o     <= '1';
						WHEN "10001" =>
							intern_o     <= '1';
						WHEN "10010" =>
							intern_o     <= '1';
						WHEN "10011" =>
							intern_o     <= '1';
						WHEN "10100" =>
							intern_o     <= '1';
						WHEN "10101" =>
							intern_o     <= '1';
						WHEN "10110" =>
							intern_o     <= '1';
						WHEN "10111" =>
							intern_o     <= '1';
						WHEN "11000" =>
							intern_o     <= '1';
						WHEN "11001" =>
							intern_o     <= '1';
						WHEN "11010" =>
							intern_o     <= '1';
						WHEN "11011" =>
							intern_o     <= '1';
						WHEN "11100" =>
							intern_o     <= '1';
						WHEN "11101" =>
							intern_o     <= '1';
						WHEN "11110" =>
							intern_o     <= '1';
						WHEN "11111" =>
							intern_o     <= '1';
						WHEN others =>
					end case;

				when x"13" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "0100";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
						when "01001" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							const_01_o   <= '1';
							n_aluclk_o   <= '0';
						when "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01100" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01101" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01110" =>
							clocks_o     <= "0101";
							enable_o     <= "0001";
							adrsel_o     <= '0';
						when "01111" =>
							n_loadpc_o   <= '0';
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						when "10000" =>
							intern_o     <= '1';
						WHEN "10001" =>
							intern_o     <= '1';
						WHEN "10010" =>
							intern_o     <= '1';
						WHEN "10011" =>
							intern_o     <= '1';
						WHEN "10100" =>
							intern_o     <= '1';
						WHEN "10101" =>
							intern_o     <= '1';
						WHEN "10110" =>
							intern_o     <= '1';
						WHEN "10111" =>
							intern_o     <= '1';
						WHEN "11000" =>
							intern_o     <= '1';
						WHEN "11001" =>
							intern_o     <= '1';
						WHEN "11010" =>
							intern_o     <= '1';
						WHEN "11011" =>
							intern_o     <= '1';
						WHEN "11100" =>
							intern_o     <= '1';
						WHEN "11101" =>
							intern_o     <= '1';
						WHEN "11110" =>
							intern_o     <= '1';
						WHEN "11111" =>
							intern_o     <= '1';
						WHEN others =>
					end case;

				when x"14" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							if vflag_i = '0' then
								intern_o     <= '1';
							else
								n_incpc_o    <= '0';
							end if;
						when "00010" =>
							if vflag_i = '0' then
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							else
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							end if;
						when "00011" =>
							intern_o     <= '1';
						when "00100" =>
							if vflag_i = '0' then
								clocks_o     <= "0101";
								enable_o     <= "0001";
							else
								intern_o     <= '1';
							end if;
						when "00101" =>
							if vflag_i = '0' then
								n_loadpc_o   <= '0';
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								intern_o     <= '1';
							end if;
						when "00110" =>
							intern_o     <= '1';
						WHEN "00111" =>
							intern_o     <= '1';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							if vflag_i = '0' then
								intern_o     <= '1';
							else
								n_incpc_o    <= '0';
							end if;
						WHEN "01010" =>
							if vflag_i = '0' then
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							else
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							end if;
						WHEN "01011" =>
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							if vflag_i = '0' then
								intern_o     <= '1';
							else
								n_incpc_o    <= '0';
							end if;
						WHEN "01110" =>
							if vflag_i = '0' then
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							else
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							end if;
						WHEN "01111" =>
							intern_o     <= '1';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							if vflag_i = '0' then
								intern_o     <= '1';
							else
								n_incpc_o    <= '0';
							end if;
						WHEN "10010" =>
							if vflag_i = '0' then
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							else
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							end if;
						WHEN "10011" =>
							intern_o     <= '1';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							if vflag_i = '0' then
								intern_o     <= '1';
							else
								n_incpc_o    <= '0';
							end if;
						WHEN "10110" =>
							if vflag_i = '0' then
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							else
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							end if;
						WHEN "10111" =>
							intern_o     <= '1';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							if vflag_i = '0' then
								intern_o     <= '1';
							else
								n_incpc_o    <= '0';
							end if;
						WHEN "11010" =>
							if vflag_i = '0' then
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							else
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							end if;
						WHEN "11011" =>
							intern_o     <= '1';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							if vflag_i = '0' then
								intern_o     <= '1';
							else
								n_incpc_o    <= '0';
							end if;
						WHEN "11110" =>
							if vflag_i = '0' then
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							else
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							end if;
						WHEN "11111" =>
							intern_o     <= '1';
						WHEN others =>
					end case;

				when x"15" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							if vflag_i = '0' then
								n_incpc_o    <= '0';
							else
								intern_o     <= '1';
							end if;
						when "00010" =>
							if vflag_i = '0' then
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							end if;
						when "00011" =>
							intern_o     <= '1';
						when "00100" =>
							if vflag_i = '0' then
								intern_o     <= '1';
							else
								clocks_o     <= "0101";
								enable_o     <= "0001";
							end if;
						when "00101" =>
							if vflag_i = '0' then
								intern_o     <= '1';
							else
								n_loadpc_o   <= '0';
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							end if;
						when "00110" =>
							intern_o     <= '1';
						WHEN "00111" =>
							intern_o     <= '1';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							if vflag_i = '0' then
								n_incpc_o    <= '0';
							else
								intern_o     <= '1';
							end if;
						WHEN "01010" =>
							if vflag_i = '0' then
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							end if;
						WHEN "01011" =>
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							if vflag_i = '0' then
								n_incpc_o    <= '0';
							else
								intern_o     <= '1';
							end if;
						WHEN "01110" =>
							if vflag_i = '0' then
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							end if;
						WHEN "01111" =>
							intern_o     <= '1';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							if vflag_i = '0' then
								n_incpc_o    <= '0';
							else
								intern_o     <= '1';
							end if;
						WHEN "10010" =>
							if vflag_i = '0' then
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							end if;
						WHEN "10011" =>
							intern_o     <= '1';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							if vflag_i = '0' then
								n_incpc_o    <= '0';
							else
								intern_o     <= '1';
							end if;
						WHEN "10110" =>
							if vflag_i = '0' then
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							end if;
						WHEN "10111" =>
							intern_o     <= '1';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							if vflag_i = '0' then
								n_incpc_o    <= '0';
							else
								intern_o     <= '1';
							end if;
						WHEN "11010" =>
							if vflag_i = '0' then
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							end if;
						WHEN "11011" =>
							intern_o     <= '1';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							if vflag_i = '0' then
								n_incpc_o    <= '0';
							else
								intern_o     <= '1';
							end if;
						WHEN "11110" =>
							if vflag_i = '0' then
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							end if;
						WHEN "11111" =>
							intern_o     <= '1';
						WHEN others =>
					end case;

				when x"16" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							if cflag_i = '0' then
								intern_o     <= '1';
							else
								n_incpc_o    <= '0';
							end if;
						when "00010" =>
							if cflag_i = '0' then
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							else
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							end if;
						when "00011" =>
							intern_o     <= '1';
						when "00100" =>
							if cflag_i = '0' then
								clocks_o     <= "0101";
								enable_o     <= "0001";
							else
								intern_o     <= '1';
							end if;
						when "00101" =>
							if cflag_i = '0' then
								n_loadpc_o   <= '0';
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								intern_o     <= '1';
							end if;
						when "00110" =>
							intern_o     <= '1';
						WHEN "00111" =>
							intern_o     <= '1';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							if cflag_i = '0' then
								intern_o     <= '1';
							else
								n_incpc_o    <= '0';
							end if;
						WHEN "01010" =>
							if cflag_i = '0' then
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							else
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							end if;
						WHEN "01011" =>
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							if cflag_i = '0' then
								intern_o     <= '1';
							else
								n_incpc_o    <= '0';
							end if;
						WHEN "01110" =>
							if cflag_i = '0' then
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							else
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							end if;
						WHEN "01111" =>
							intern_o     <= '1';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							if cflag_i = '0' then
								intern_o     <= '1';
							else
								n_incpc_o    <= '0';
							end if;
						WHEN "10010" =>
							if cflag_i = '0' then
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							else
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							end if;
						WHEN "10011" =>
							intern_o     <= '1';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							if cflag_i = '0' then
								intern_o     <= '1';
							else
								n_incpc_o    <= '0';
							end if;
						WHEN "10110" =>
							if cflag_i = '0' then
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							else
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							end if;
						WHEN "10111" =>
							intern_o     <= '1';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							if cflag_i = '0' then
								intern_o     <= '1';
							else
								n_incpc_o    <= '0';
							end if;
						WHEN "11010" =>
							if cflag_i = '0' then
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							else
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							end if;
						WHEN "11011" =>
							intern_o     <= '1';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							if cflag_i = '0' then
								intern_o     <= '1';
							else
								n_incpc_o    <= '0';
							end if;
						WHEN "11110" =>
							if cflag_i = '0' then
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							else
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							end if;
						WHEN "11111" =>
							intern_o     <= '1';
						WHEN others =>
					end case;

				when x"17" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							if cflag_i = '0' then
								n_incpc_o    <= '0';
							else
								intern_o     <= '1';
							end if;
						when "00010" =>
							if cflag_i = '0' then
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							end if;
						when "00011" =>
							intern_o     <= '1';
						when "00100" =>
							if cflag_i = '0' then
								intern_o     <= '1';
							else
								clocks_o     <= "0101";
								enable_o     <= "0001";
							end if;
						when "00101" =>
							if cflag_i = '0' then
								intern_o     <= '1';
							else
								n_loadpc_o   <= '0';
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							end if;
						when "00110" =>
							intern_o     <= '1';
						WHEN "00111" =>
							intern_o     <= '1';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							if cflag_i = '0' then
								n_incpc_o    <= '0';
							else
								intern_o     <= '1';
							end if;
						WHEN "01010" =>
							if cflag_i = '0' then
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							end if;
						WHEN "01011" =>
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							if cflag_i = '0' then
								n_incpc_o    <= '0';
							else
								intern_o     <= '1';
							end if;
						WHEN "01110" =>
							if cflag_i = '0' then
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							end if;
						WHEN "01111" =>
							intern_o     <= '1';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							if cflag_i = '0' then
								n_incpc_o    <= '0';
							else
								intern_o     <= '1';
							end if;
						WHEN "10010" =>
							if cflag_i = '0' then
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							end if;
						WHEN "10011" =>
							intern_o     <= '1';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							if cflag_i = '0' then
								n_incpc_o    <= '0';
							else
								intern_o     <= '1';
							end if;
						WHEN "10110" =>
							if cflag_i = '0' then
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							end if;
						WHEN "10111" =>
							intern_o     <= '1';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							if cflag_i = '0' then
								n_incpc_o    <= '0';
							else
								intern_o     <= '1';
							end if;
						WHEN "11010" =>
							if cflag_i = '0' then
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							end if;
						WHEN "11011" =>
							intern_o     <= '1';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							if cflag_i = '0' then
								n_incpc_o    <= '0';
							else
								intern_o     <= '1';
							end if;
						WHEN "11110" =>
							if cflag_i = '0' then
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							end if;
						WHEN "11111" =>
							intern_o     <= '1';
						WHEN others =>
					end case;

				when x"18" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							if zflag_i = '0' then
								intern_o     <= '1';
							else
								n_incpc_o    <= '0';
							end if;
						when "00010" =>
							if zflag_i = '0' then
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							else
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							end if;
						when "00011" =>
							intern_o     <= '1';
						when "00100" =>
							if zflag_i = '0' then
								clocks_o     <= "0101";
								enable_o     <= "0001";
							else
								intern_o     <= '1';
							end if;
						when "00101" =>
							if zflag_i = '0' then
								n_loadpc_o   <= '0';
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								intern_o     <= '1';
							end if;
						when "00110" =>
							intern_o     <= '1';
						WHEN "00111" =>
							intern_o     <= '1';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							if zflag_i = '0' then
								intern_o     <= '1';
							else
								n_incpc_o    <= '0';
							end if;
						WHEN "01010" =>
							if zflag_i = '0' then
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							else
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							end if;
						WHEN "01011" =>
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							if zflag_i = '0' then
								intern_o     <= '1';
							else
								n_incpc_o    <= '0';
							end if;
						WHEN "01110" =>
							if zflag_i = '0' then
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							else
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							end if;
						WHEN "01111" =>
							intern_o     <= '1';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							if zflag_i = '0' then
								intern_o     <= '1';
							else
								n_incpc_o    <= '0';
							end if;
						WHEN "10010" =>
							if zflag_i = '0' then
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							else
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							end if;
						WHEN "10011" =>
							intern_o     <= '1';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							if zflag_i = '0' then
								intern_o     <= '1';
							else
								n_incpc_o    <= '0';
							end if;
						WHEN "10110" =>
							if zflag_i = '0' then
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							else
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							end if;
						WHEN "10111" =>
							intern_o     <= '1';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							if zflag_i = '0' then
								intern_o     <= '1';
							else
								n_incpc_o    <= '0';
							end if;
						WHEN "11010" =>
							if zflag_i = '0' then
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							else
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							end if;
						WHEN "11011" =>
							intern_o     <= '1';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							if zflag_i = '0' then
								intern_o     <= '1';
							else
								n_incpc_o    <= '0';
							end if;
						WHEN "11110" =>
							if zflag_i = '0' then
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							else
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							end if;
						WHEN "11111" =>
							intern_o     <= '1';
						WHEN others =>
					end case;

				when x"19" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							if zflag_i = '0' then
								n_incpc_o    <= '0';
							else
								intern_o     <= '1';
							end if;
						when "00010" =>
							if zflag_i = '0' then
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							end if;
						when "00011" =>
							intern_o     <= '1';
						when "00100" =>
							if zflag_i = '0' then
								intern_o     <= '1';
							else
								clocks_o     <= "0101";
								enable_o     <= "0001";
							end if;
						when "00101" =>
							if zflag_i = '0' then
								intern_o     <= '1';
							else
								n_loadpc_o   <= '0';
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							end if;
						when "00110" =>
							intern_o     <= '1';
						WHEN "00111" =>
							intern_o     <= '1';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							if zflag_i = '0' then
								n_incpc_o    <= '0';
							else
								intern_o     <= '1';
							end if;
						WHEN "01010" =>
							if zflag_i = '0' then
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							end if;
						WHEN "01011" =>
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							if zflag_i = '0' then
								n_incpc_o    <= '0';
							else
								intern_o     <= '1';
							end if;
						WHEN "01110" =>
							if zflag_i = '0' then
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							end if;
						WHEN "01111" =>
							intern_o     <= '1';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							if zflag_i = '0' then
								n_incpc_o    <= '0';
							else
								intern_o     <= '1';
							end if;
						WHEN "10010" =>
							if zflag_i = '0' then
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							end if;
						WHEN "10011" =>
							intern_o     <= '1';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							if zflag_i = '0' then
								n_incpc_o    <= '0';
							else
								intern_o     <= '1';
							end if;
						WHEN "10110" =>
							if zflag_i = '0' then
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							end if;
						WHEN "10111" =>
							intern_o     <= '1';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							if zflag_i = '0' then
								n_incpc_o    <= '0';
							else
								intern_o     <= '1';
							end if;
						WHEN "11010" =>
							if zflag_i = '0' then
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							end if;
						WHEN "11011" =>
							intern_o     <= '1';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							if zflag_i = '0' then
								n_incpc_o    <= '0';
							else
								intern_o     <= '1';
							end if;
						WHEN "11110" =>
							if zflag_i = '0' then
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "0100";
								enable_o     <= "0001";
								n_incpc_o    <= '0';
							end if;
						WHEN "11111" =>
							intern_o     <= '1';
						WHEN others =>
					end case;

				when x"1A" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
							intern_o     <= '1';
						when "00100" =>
							clocks_o     <= "0101";
							enable_o     <= "0001";
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0111";
							enable_o     <= "0100";
							alu_mode_o   <= "1111";
							adrsel_o     <= '0';
						when "00111" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							n_aluclk_o   <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "1101";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01001" =>
							clocks_o     <= "0111";
							enable_o     <= "0011";
							alu_mode_o   <= "1111";
							n_loadpc_o   <= '0';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						when "01010" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01011" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0101";
							enable_o     <= "0001";
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "01110" =>
							clocks_o     <= "0111";
							enable_o     <= "0100";
							alu_mode_o   <= "1111";
							adrsel_o     <= '0';
						WHEN "01111" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							n_aluclk_o   <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
							intern_o     <= '1';
						WHEN "10100" =>
							clocks_o     <= "0101";
							enable_o     <= "0001";
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0111";
							enable_o     <= "0100";
							alu_mode_o   <= "1111";
							adrsel_o     <= '0';
						WHEN "10111" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							n_aluclk_o   <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
							intern_o     <= '1';
						WHEN "11100" =>
							clocks_o     <= "0101";
							enable_o     <= "0001";
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0111";
							enable_o     <= "0100";
							alu_mode_o   <= "1111";
							adrsel_o     <= '0';
						WHEN "11111" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							n_aluclk_o   <= '0';
						WHEN others =>
					end case;

				when x"1B" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
							intern_o     <= '1';
						when "00100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0100";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00111" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01001" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01010" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01011" =>
							clocks_o     <= "0101";
							enable_o     <= "0010";
							adrsel_o     <= '0';
						when "01100" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							alu_mode_o   <= "1111";
							const_01_o   <= '1';
						when "01101" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
						when "01110" =>
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01111" =>
							clocks_o     <= "0111";
							enable_o     <= "0100";
							adrsel_o     <= '0';
						when "10000" =>
							clocks_o     <= "0010";
							enable_o     <= "1101";
						when "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1101";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "10010" =>
							clocks_o     <= "0111";
							enable_o     <= "0011";
							alu_mode_o   <= "1111";
							n_loadpc_o   <= '0';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						when "10011" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0100";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10111" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11000" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11010" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11011" =>
							clocks_o     <= "0101";
							enable_o     <= "0010";
							adrsel_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							alu_mode_o   <= "1111";
							const_01_o   <= '1';
						WHEN "11101" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
						WHEN "11110" =>
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "0111";
							enable_o     <= "0100";
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"1C" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01001" =>
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "01011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"1D" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							alu_mode_o   <= "1110";
							const_01_o   <= '1';
						when "00010" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1101";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "0100";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1101";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "0101";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "01010" =>
							clocks_o     <= "1000";
							enable_o     <= "1101";
							intern_o     <= '1';
							n_loadpc_o   <= '0';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "01011" =>
							enable_o     <= "0010";
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
							n_mend_o     <= '0';
						when "01100" =>
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "01101" =>
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "01110" =>
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "01111" =>
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "10000" =>
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "10001" =>
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "10010" =>
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "10011" =>
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "10100" =>
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "10101" =>
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "10110" =>
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "10111" =>
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "11000" =>
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "11001" =>
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "11010" =>
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "11011" =>
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "11100" =>
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "11101" =>
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "11110" =>
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "11111" =>
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN others =>
					end case;

				when x"1E" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							alu_mode_o   <= "1110";
							const_01_o   <= '1';
						when "00010" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1101";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "0100";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1101";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "0101";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "01010" =>
							clocks_o     <= "1000";
							enable_o     <= "1101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01011" =>
							enable_o     <= "0010";
							n_loadpc_o   <= '0';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						when "01100" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "01101" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "01111" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "10000" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "10001" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "10011" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "10100" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "10101" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "10111" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "11000" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "11001" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "11011" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "11100" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "11101" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN "11111" =>
							clocks_o     <= "1101";
							enable_o     <= "0111";
							alu_fsel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
						WHEN others =>
					end case;

				when x"1F" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							alu_mode_o   <= "1110";
							const_01_o   <= '1';
						when "00010" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1101";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "0100";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1000";
							enable_o     <= "1101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "0101";
							enable_o     <= "0010";
							adrsel_o     <= '0';
						when "01001" =>
							n_loadpc_o   <= '0';
							n_incpc_o    <= '0';
						when "01010" =>
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						when "01011" =>
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "1110";
							enable_o     <= "1101";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "01101" =>
							clocks_o     <= "0100";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1000";
							enable_o     <= "1101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							alu_mode_o   <= "1110";
							const_01_o   <= '1';
						WHEN "10010" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "1101";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "0100";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1000";
							enable_o     <= "1101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							alu_mode_o   <= "1110";
							const_01_o   <= '1';
						WHEN "11010" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						WHEN "11011" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11100" =>
							clocks_o     <= "1110";
							enable_o     <= "1101";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "0100";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1000";
							enable_o     <= "1101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"20" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						when "00010" =>
							if cflag_i = '0' then
								clocks_o     <= "1010";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1010";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "00011" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "00110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "01010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "01110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "10010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "10110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "11010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "11110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN others =>
					end case;

				when x"21" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						when "00010" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "00011" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "00110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "01010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "01110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "10010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "10110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "11010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "11110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN others =>
					end case;

				when x"22" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						when "00010" =>
							if cflag_i = '0' then
								clocks_o     <= "1011";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1011";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "00011" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "00110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "01010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "01110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "10010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "10110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "11010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "11110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1001";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN others =>
					end case;

				when x"23" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						when "00010" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "00011" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "00110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "01010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "01110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "10010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "10110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "11010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "11110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN others =>
					end case;

				when x"24" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						when "00010" =>
							if cflag_i = '0' then
								clocks_o     <= "1011";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1011";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "00011" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "00110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "01010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "01110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "10010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "10110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "11010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "11110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN others =>
					end case;

				when x"25" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						when "00010" =>
							if cflag_i = '0' then
								clocks_o     <= "1010";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1010";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "00011" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "00110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "01010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "01110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "10010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "10110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "11010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "11110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1011";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN others =>
					end case;

				when x"26" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1000";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1000";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						when "00010" =>
							if cflag_i = '0' then
								clocks_o     <= "1010";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1010";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "00011" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1000";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1000";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1000";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1000";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "00110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1000";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1000";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1000";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1000";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "01010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1000";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1000";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1000";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1000";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "01110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1000";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1000";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1000";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1000";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "10010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1000";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1000";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1000";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1000";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "10110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1000";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1000";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1000";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1000";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "11010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1000";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1000";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1000";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1000";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "11110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1000";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1000";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN others =>
					end case;

				when x"27" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						when "00010" =>
							if cflag_i = '0' then
								clocks_o     <= "1000";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1000";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "00011" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "00110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "01010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "01110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "10010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "10110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "11010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN "11110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1000";
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "1010";
								alu_mode_o   <= "1001";
								n_mend_o     <= '0';
							end if;
						WHEN others =>
					end case;

				when x"28" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1100";
							enable_o     <= "1001";
						when "00010" =>
							clocks_o     <= "1001";
							enable_o     <= "1010";
							n_mend_o     <= '0';
						when "00011" =>
							clocks_o     <= "1010";
							enable_o     <= "1100";
							intern_o     <= '1';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							clocks_o     <= "1100";
							enable_o     <= "1001";
						WHEN others =>
					end case;

				when x"29" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1100";
							enable_o     <= "1001";
						when "00010" =>
							clocks_o     <= "1001";
							enable_o     <= "1011";
							n_mend_o     <= '0';
						when "00011" =>
							clocks_o     <= "1011";
							enable_o     <= "1100";
							intern_o     <= '1';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							clocks_o     <= "1100";
							enable_o     <= "1001";
						WHEN others =>
					end case;

				when x"2A" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1100";
							enable_o     <= "1010";
						when "00010" =>
							clocks_o     <= "1010";
							enable_o     <= "1011";
							n_mend_o     <= '0';
						when "00011" =>
							clocks_o     <= "1011";
							enable_o     <= "1100";
							intern_o     <= '1';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							clocks_o     <= "1100";
							enable_o     <= "1010";
						WHEN others =>
					end case;

				when x"2B" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							n_mend_o     <= '0';
						when "00010" =>
							intern_o     <= '1';
						WHEN "00011" =>
							n_mend_o     <= '0';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							n_mend_o     <= '0';
						WHEN "00110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							n_mend_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							n_mend_o     <= '0';
						WHEN "01010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							n_mend_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							n_mend_o     <= '0';
						WHEN "01110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							n_mend_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							n_mend_o     <= '0';
						WHEN "10010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							n_mend_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							n_mend_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							n_mend_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							n_mend_o     <= '0';
						WHEN "11010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							n_mend_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							n_mend_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							n_mend_o     <= '0';
						WHEN others =>
					end case;

				when x"2C" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1001";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						when "00010" =>
							enable_o     <= "0101";
							alu_fsel_o   <= '1';
							n_alu_ldvz_o <= '0';
							const_02_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00011" =>
							clocks_o     <= "1001";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							clocks_o     <= "1001";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "00110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							clocks_o     <= "1001";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "1001";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "01010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							clocks_o     <= "1001";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "1001";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "01110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							clocks_o     <= "1001";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1001";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "10010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "1001";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "1001";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							clocks_o     <= "1001";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1001";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "11010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "1001";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "1001";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							clocks_o     <= "1001";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN others =>
					end case;

				when x"2D" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1010";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						when "00010" =>
							enable_o     <= "0101";
							alu_fsel_o   <= '1';
							n_alu_ldvz_o <= '0';
							const_02_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00011" =>
							clocks_o     <= "1010";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							clocks_o     <= "1010";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "00110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							clocks_o     <= "1010";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "1010";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "01010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							clocks_o     <= "1010";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "1010";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "01110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							clocks_o     <= "1010";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1010";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "10010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "1010";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "1010";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							clocks_o     <= "1010";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1010";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "11010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "1010";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "1010";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							clocks_o     <= "1010";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN others =>
					end case;

				when x"2E" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1011";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						when "00010" =>
							enable_o     <= "0101";
							alu_fsel_o   <= '1';
							n_alu_ldvz_o <= '0';
							const_02_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00011" =>
							clocks_o     <= "1011";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							clocks_o     <= "1011";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "00110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							clocks_o     <= "1011";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "1011";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "01010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							clocks_o     <= "1011";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "1011";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "01110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							clocks_o     <= "1011";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1011";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "10010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "1011";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "1011";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							clocks_o     <= "1011";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1011";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "11010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "1011";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "1011";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							clocks_o     <= "1011";
							enable_o     <= "0101";
							n_mend_o     <= '0';
						WHEN others =>
					end case;

				when x"2F" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							intern_o     <= '1';
						when "00100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						when "00101" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0111";
							enable_o     <= "0101";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "00111" =>
							intern_o     <= '1';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							intern_o     <= '1';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							intern_o     <= '1';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							intern_o     <= '1';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							intern_o     <= '1';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							intern_o     <= '1';
						WHEN others =>
					end case;

				when x"30" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
							end if;
						when "00010" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "0001";
								alu_mode_o   <= "1000";
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "0001";
								alu_mode_o   <= "1001";
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							end if;
						when "00011" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
							end if;
						WHEN others =>
					end case;

				when x"31" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						when "00011" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							end if;
						when "00100" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "0010";
								alu_mode_o   <= "1000";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "0010";
								alu_mode_o   <= "1001";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							end if;
						when "00101" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "00111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							end if;
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "01011" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							end if;
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "01111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							end if;
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "10011" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							end if;
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "10111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							end if;
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "11011" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							end if;
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "11111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							end if;
						WHEN others =>
					end case;

				when x"32" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							intern_o     <= '1';
						when "00100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						when "00101" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							end if;
						when "00110" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "0010";
								alu_mode_o   <= "1000";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "0010";
								alu_mode_o   <= "1001";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							end if;
						when "00111" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							intern_o     <= '1';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							intern_o     <= '1';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							intern_o     <= '1';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							intern_o     <= '1';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							intern_o     <= '1';
						WHEN others =>
					end case;

				when x"33" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1101";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01011" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
							end if;
						when "01100" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "0010";
								alu_mode_o   <= "1000";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "0010";
								alu_mode_o   <= "1001";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							end if;
						when "01101" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "11100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"34" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1101";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01011" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
							end if;
						when "01100" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "0010";
								alu_mode_o   <= "1000";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "0010";
								alu_mode_o   <= "1001";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							end if;
						when "01101" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "11100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"35" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
							end if;
						when "01000" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "0010";
								alu_mode_o   <= "1000";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "0010";
								alu_mode_o   <= "1001";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							end if;
						when "01001" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "01010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "01011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
							end if;
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
							end if;
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
							end if;
						WHEN others =>
					end case;

				when x"36" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
							end if;
						when "01000" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "0010";
								alu_mode_o   <= "1000";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "0010";
								alu_mode_o   <= "1001";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							end if;
						when "01001" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "01010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "01011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
							end if;
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
							end if;
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
							end if;
						WHEN others =>
					end case;

				when x"37" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
							end if;
						when "01000" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "0001";
								alu_mode_o   <= "1000";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "0001";
								alu_mode_o   <= "1001";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							end if;
						when "01001" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "01010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "01011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
							end if;
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
							end if;
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
							end if;
						WHEN others =>
					end case;

				when x"38" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
							end if;
						when "01000" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "0001";
								alu_mode_o   <= "1000";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "0001";
								alu_mode_o   <= "1001";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							end if;
						when "01001" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "01010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "01011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
							end if;
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
							end if;
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
							end if;
						WHEN others =>
					end case;

				when x"39" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1101";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01011" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
							end if;
						when "01100" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "0001";
								alu_mode_o   <= "1000";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "0001";
								alu_mode_o   <= "1001";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							end if;
						when "01101" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "11100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"3A" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1101";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01011" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
							end if;
						when "01100" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "0001";
								alu_mode_o   <= "1000";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "0001";
								alu_mode_o   <= "1001";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							end if;
						when "01101" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "11100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"3B" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							intern_o     <= '1';
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1011";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00011" =>
							clocks_o     <= "1110";
							enable_o     <= "0011";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
						when "00100" =>
							clocks_o     <= "0100";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0100";
							alu_mode_o   <= "1001";
							alu_csel_o   <= '1';
							intern_o     <= '1';
						when "00110" =>
							clocks_o     <= "0101";
							enable_o     <= "1111";
							alu_mode_o   <= "1001";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							if zflag_i = '0' then
								intern_o     <= '1';
								n_loadpc_o   <= '0';
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								intern_o     <= '1';
								n_mend_o     <= '0';
							end if;
						when "01000" =>
							intern_o     <= '1';
						WHEN "01001" =>
							intern_o     <= '1';
						WHEN "01010" =>
							intern_o     <= '1';
						WHEN "01011" =>
							intern_o     <= '1';
						WHEN "01100" =>
							intern_o     <= '1';
						WHEN "01101" =>
							intern_o     <= '1';
						WHEN "01110" =>
							intern_o     <= '1';
						WHEN "01111" =>
							intern_o     <= '1';
						WHEN "10000" =>
							intern_o     <= '1';
						WHEN "10001" =>
							intern_o     <= '1';
						WHEN "10010" =>
							intern_o     <= '1';
						WHEN "10011" =>
							intern_o     <= '1';
						WHEN "10100" =>
							intern_o     <= '1';
						WHEN "10101" =>
							intern_o     <= '1';
						WHEN "10110" =>
							intern_o     <= '1';
						WHEN "10111" =>
							intern_o     <= '1';
						WHEN "11000" =>
							intern_o     <= '1';
						WHEN "11001" =>
							intern_o     <= '1';
						WHEN "11010" =>
							intern_o     <= '1';
						WHEN "11011" =>
							intern_o     <= '1';
						WHEN "11100" =>
							intern_o     <= '1';
						WHEN "11101" =>
							intern_o     <= '1';
						WHEN "11110" =>
							intern_o     <= '1';
						WHEN "11111" =>
							intern_o     <= '1';
						WHEN others =>
					end case;

				when x"3C" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						when "00011" =>
							alu_mode_o   <= "0110";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "0110";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "00101" =>
							alu_mode_o   <= "0110";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "00111" =>
							alu_mode_o   <= "0110";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "01011" =>
							alu_mode_o   <= "0110";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "01111" =>
							alu_mode_o   <= "0110";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "10011" =>
							alu_mode_o   <= "0110";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "10111" =>
							alu_mode_o   <= "0110";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "11011" =>
							alu_mode_o   <= "0110";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "11111" =>
							alu_mode_o   <= "0110";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN others =>
					end case;

				when x"3D" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						when "00011" =>
							alu_mode_o   <= "1010";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1010";
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1111";
							enable_o     <= "1111";
							alu_mode_o   <= "1010";
							n_aluclk_o   <= '0';
						when "00110" =>
							alu_mode_o   <= "1011";
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1111";
							alu_mode_o   <= "1011";
							n_aluclk_o   <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "1111";
							alu_mode_o   <= "1011";
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "1110";
							enable_o     <= "1111";
							alu_mode_o   <= "1011";
							n_aluclk_o   <= '0';
						when "01010" =>
							clocks_o     <= "1110";
							enable_o     <= "1111";
							alu_mode_o   <= "1011";
							n_aluclk_o   <= '0';
						when "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1111";
							alu_mode_o   <= "1011";
							n_aluclk_o   <= '0';
						when "01100" =>
							clocks_o     <= "1110";
							enable_o     <= "1111";
							alu_mode_o   <= "1011";
							n_aluclk_o   <= '0';
						when "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "1111";
							alu_mode_o   <= "1011";
							n_aluclk_o   <= '0';
						when "01110" =>
							alu_mode_o   <= "0001";
							n_mend_o     <= '0';
						when "01111" =>
							alu_mode_o   <= "0001";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "10011" =>
							alu_mode_o   <= "1010";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1010";
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "1111";
							enable_o     <= "1111";
							alu_mode_o   <= "1010";
							n_aluclk_o   <= '0';
						WHEN "10110" =>
							alu_mode_o   <= "1011";
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1111";
							alu_mode_o   <= "1011";
							n_aluclk_o   <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "11011" =>
							alu_mode_o   <= "1010";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1010";
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "1111";
							enable_o     <= "1111";
							alu_mode_o   <= "1010";
							n_aluclk_o   <= '0';
						WHEN "11110" =>
							alu_mode_o   <= "1011";
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1111";
							alu_mode_o   <= "1011";
							n_aluclk_o   <= '0';
						WHEN others =>
					end case;

				when x"3E" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0010";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						when "00011" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1111";
							enable_o     <= "0101";
							alu_mode_o   <= "0001";
							intern_o     <= '1';
						when "00110" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							alu_mode_o   <= "0001";
						when "00111" =>
							alu_mode_o   <= "0001";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01000" =>
							clocks_o     <= "0111";
							enable_o     <= "1100";
							adrsel_o     <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						when "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						when "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "01100" =>
							clocks_o     <= "0111";
							enable_o     <= "1101";
							alu_mode_o   <= "1111";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01101" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01110" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							alu_mode_o   <= "0001";
						WHEN "01111" =>
							alu_mode_o   <= "0001";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0010";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						WHEN "10011" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "1111";
							enable_o     <= "0101";
							alu_mode_o   <= "0001";
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							alu_mode_o   <= "0001";
						WHEN "10111" =>
							alu_mode_o   <= "0001";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0010";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						WHEN "11011" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "1111";
							enable_o     <= "0101";
							alu_mode_o   <= "0001";
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							alu_mode_o   <= "0001";
						WHEN "11111" =>
							alu_mode_o   <= "0001";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN others =>
					end case;

				when x"3F" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00011" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						when "00100" =>
							clocks_o     <= "1000";
							enable_o     <= "1101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1100";
							enable_o     <= "0010";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00111" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						when "01000" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "01001" =>
							clocks_o     <= "0111";
							enable_o     <= "1100";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01010" =>
							intern_o     <= '1';
						WHEN "01011" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "01100" =>
							clocks_o     <= "1000";
							enable_o     <= "1101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "01101" =>
							clocks_o     <= "1100";
							enable_o     <= "0010";
							adrsel_o     <= '0';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01111" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10011" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "10100" =>
							clocks_o     <= "1000";
							enable_o     <= "1101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "1100";
							enable_o     <= "0010";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10111" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11011" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "11100" =>
							clocks_o     <= "1000";
							enable_o     <= "1101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "1100";
							enable_o     <= "0010";
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11111" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						WHEN others =>
					end case;

				when x"40" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "0101";
							alu_mode_o   <= "1010";
							const_02_o   <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "1111";
							alu_mode_o   <= "1010";
							n_aluclk_o   <= '0';
						when "00011" =>
							clocks_o     <= "1110";
							enable_o     <= "1101";
							alu_mode_o   <= "0101";
						when "00100" =>
							clocks_o     <= "1111";
							enable_o     <= "1111";
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						when "00110" =>
							clocks_o     <= "1100";
							enable_o     <= "1111";
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						when "00111" =>
							alu_mode_o   <= "0111";
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "1111";
							alu_mode_o   <= "0111";
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "1111";
							enable_o     <= "1100";
							alu_mode_o   <= "0001";
							n_mend_o     <= '0';
						when "01010" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0001";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1101";
							alu_mode_o   <= "0101";
						WHEN "01100" =>
							clocks_o     <= "1111";
							enable_o     <= "1111";
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN "01110" =>
							clocks_o     <= "1100";
							enable_o     <= "1111";
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							alu_mode_o   <= "0111";
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "0101";
							alu_mode_o   <= "1010";
							const_02_o   <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "1111";
							alu_mode_o   <= "1010";
							n_aluclk_o   <= '0';
						WHEN "10011" =>
							clocks_o     <= "1110";
							enable_o     <= "1101";
							alu_mode_o   <= "0101";
						WHEN "10100" =>
							clocks_o     <= "1111";
							enable_o     <= "1111";
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN "10110" =>
							clocks_o     <= "1100";
							enable_o     <= "1111";
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							alu_mode_o   <= "0111";
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "0101";
							alu_mode_o   <= "1010";
							const_02_o   <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "1111";
							alu_mode_o   <= "1010";
							n_aluclk_o   <= '0';
						WHEN "11011" =>
							clocks_o     <= "1110";
							enable_o     <= "1101";
							alu_mode_o   <= "0101";
						WHEN "11100" =>
							clocks_o     <= "1111";
							enable_o     <= "1111";
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN "11110" =>
							clocks_o     <= "1100";
							enable_o     <= "1111";
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							alu_mode_o   <= "0111";
						WHEN others =>
					end case;

				when x"41" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						when "00011" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0111";
							enable_o     <= "1001";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "00101" =>
							intern_o     <= '1';
						WHEN "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "00111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "01011" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "01111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "10011" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "10111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "11011" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "11111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN others =>
					end case;

				when x"42" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							intern_o     <= '1';
						when "00100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						when "00101" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0111";
							enable_o     <= "1001";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "00111" =>
							intern_o     <= '1';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							intern_o     <= '1';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							intern_o     <= '1';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							intern_o     <= '1';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							intern_o     <= '1';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							intern_o     <= '1';
						WHEN others =>
					end case;

				when x"43" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1101";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01011" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01100" =>
							clocks_o     <= "0111";
							enable_o     <= "1001";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01101" =>
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "11100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"44" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1101";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01011" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01100" =>
							clocks_o     <= "0111";
							enable_o     <= "1001";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01101" =>
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "11100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"45" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "0111";
							enable_o     <= "1001";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01001" =>
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "01011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"46" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "0111";
							enable_o     <= "1001";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01001" =>
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "01011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"47" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "1110";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						when "00101" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0001";
							adrsel_o     <= '0';
						when "00111" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
							alu_mode_o   <= "0001";
						when "01000" =>
							alu_mode_o   <= "0001";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "0111";
							enable_o     <= "1101";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01010" =>
							intern_o     <= '1';
						WHEN "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "01101" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0001";
							adrsel_o     <= '0';
						WHEN "01111" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
							alu_mode_o   <= "0001";
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "1110";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "10101" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0001";
							adrsel_o     <= '0';
						WHEN "10111" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
							alu_mode_o   <= "0001";
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "1110";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "11101" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0001";
							adrsel_o     <= '0';
						WHEN "11111" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
							alu_mode_o   <= "0001";
						WHEN others =>
					end case;

				when x"48" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00100" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
						when "00101" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0111";
							enable_o     <= "1100";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "00111" =>
							intern_o     <= '1';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN others =>
					end case;

				when x"49" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0100";
							enable_o     <= "0001";
							alu_mode_o   <= "1111";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "1010";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00100" =>
							clocks_o     <= "0101";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00101" =>
							if zflag_i = '0' then
								n_loadpc_o   <= '0';
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								n_mend_o     <= '0';
							end if;
						when "00110" =>
							intern_o     <= '1';
						WHEN "00111" =>
							clocks_o     <= "1010";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0100";
							enable_o     <= "0001";
							alu_mode_o   <= "1111";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							clocks_o     <= "1010";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0100";
							enable_o     <= "0001";
							alu_mode_o   <= "1111";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							clocks_o     <= "1010";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0100";
							enable_o     <= "0001";
							alu_mode_o   <= "1111";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "1010";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0100";
							enable_o     <= "0001";
							alu_mode_o   <= "1111";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							clocks_o     <= "1010";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0100";
							enable_o     <= "0001";
							alu_mode_o   <= "1111";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "1010";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0100";
							enable_o     <= "0001";
							alu_mode_o   <= "1111";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							clocks_o     <= "1010";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN others =>
					end case;

				when x"4A" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0100";
							enable_o     <= "0001";
							alu_mode_o   <= "1111";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "1011";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00100" =>
							clocks_o     <= "0101";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00101" =>
							if zflag_i = '0' then
								n_loadpc_o   <= '0';
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								n_mend_o     <= '0';
							end if;
						when "00110" =>
							intern_o     <= '1';
						WHEN "00111" =>
							clocks_o     <= "1011";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0100";
							enable_o     <= "0001";
							alu_mode_o   <= "1111";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							clocks_o     <= "1011";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0100";
							enable_o     <= "0001";
							alu_mode_o   <= "1111";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							clocks_o     <= "1011";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0100";
							enable_o     <= "0001";
							alu_mode_o   <= "1111";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "1011";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0100";
							enable_o     <= "0001";
							alu_mode_o   <= "1111";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							clocks_o     <= "1011";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0100";
							enable_o     <= "0001";
							alu_mode_o   <= "1111";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "1011";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0100";
							enable_o     <= "0001";
							alu_mode_o   <= "1111";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							clocks_o     <= "1011";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN others =>
					end case;

				when x"4B" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							intern_o     <= '1';
						when "00011" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
						when "00100" =>
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "00101" =>
							clocks_o     <= "1100";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "0011";
							enable_o     <= "0010";
							adrsel_o     <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						when "01010" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
							end if;
						when "01011" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "0010";
								alu_mode_o   <= "1000";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "0010";
								alu_mode_o   <= "1001";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							end if;
						when "01100" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "01101" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "01110" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "01111" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "10000" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "10001" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "10010" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "10011" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "10100" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "10101" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "10110" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "10111" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "11000" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "11001" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "11010" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "11011" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "11100" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "11101" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "11110" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "11111" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN others =>
					end case;

				when x"4C" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1100";
							enable_o     <= "1001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1001";
							enable_o     <= "0001";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01001" =>
							clocks_o     <= "1010";
							enable_o     <= "1100";
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "01011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1100";
							enable_o     <= "1001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1100";
							enable_o     <= "1001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1100";
							enable_o     <= "1001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"4D" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						when "00010" =>
							intern_o     <= '1';
						WHEN "00011" =>
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "00110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "01010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "01110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "10010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "11010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN others =>
					end case;

				when x"4E" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							n_incpc_o    <= '0';
						when "00010" =>
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						when "00011" =>
							intern_o     <= '1';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							n_incpc_o    <= '0';
						WHEN others =>
					end case;

				when x"4F" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							n_incpc_o    <= '0';
						when "00010" =>
							n_incpc_o    <= '0';
						when "00011" =>
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						when "00100" =>
							intern_o     <= '1';
						WHEN "00101" =>
							n_incpc_o    <= '0';
						WHEN "00110" =>
							n_incpc_o    <= '0';
						WHEN "00111" =>
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							n_incpc_o    <= '0';
						WHEN "01010" =>
							n_incpc_o    <= '0';
						WHEN "01011" =>
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							n_incpc_o    <= '0';
						WHEN "01110" =>
							n_incpc_o    <= '0';
						WHEN "01111" =>
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							n_incpc_o    <= '0';
						WHEN "10010" =>
							n_incpc_o    <= '0';
						WHEN "10011" =>
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							n_incpc_o    <= '0';
						WHEN "10110" =>
							n_incpc_o    <= '0';
						WHEN "10111" =>
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							n_incpc_o    <= '0';
						WHEN "11010" =>
							n_incpc_o    <= '0';
						WHEN "11011" =>
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							n_incpc_o    <= '0';
						WHEN "11110" =>
							n_incpc_o    <= '0';
						WHEN "11111" =>
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN others =>
					end case;

				when x"50" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
							end if;
						when "00010" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "0001";
								alu_mode_o   <= "1000";
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "0001";
								alu_mode_o   <= "1001";
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							end if;
						when "00011" =>
							if cflag_i = '0' then
								clocks_o     <= "1010";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1010";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
							end if;
						WHEN others =>
					end case;

				when x"51" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						when "00011" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							end if;
						when "00100" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "0010";
								alu_mode_o   <= "1000";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "0010";
								alu_mode_o   <= "1001";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							end if;
						when "00101" =>
							if cflag_i = '0' then
								clocks_o     <= "1010";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1010";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "00111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							end if;
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "01011" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							end if;
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "01111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							end if;
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "10011" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							end if;
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "10111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							end if;
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "11011" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							end if;
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "11111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							end if;
						WHEN others =>
					end case;

				when x"52" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							intern_o     <= '1';
						when "00100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						when "00101" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							end if;
						when "00110" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "0010";
								alu_mode_o   <= "1000";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "0010";
								alu_mode_o   <= "1001";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							end if;
						when "00111" =>
							if cflag_i = '0' then
								clocks_o     <= "1010";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1010";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							intern_o     <= '1';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							intern_o     <= '1';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							intern_o     <= '1';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							intern_o     <= '1';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							intern_o     <= '1';
						WHEN others =>
					end case;

				when x"53" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
							end if;
						when "01000" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "0010";
								alu_mode_o   <= "1000";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "0010";
								alu_mode_o   <= "1001";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							end if;
						when "01001" =>
							if cflag_i = '0' then
								clocks_o     <= "1010";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1010";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "01010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "01011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
							end if;
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
							end if;
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
							end if;
						WHEN others =>
					end case;

				when x"54" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						when "00011" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0111";
							enable_o     <= "1010";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "00101" =>
							intern_o     <= '1';
						WHEN "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "00111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "01011" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "01111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "10011" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "10111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "11011" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "11111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN others =>
					end case;

				when x"55" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							intern_o     <= '1';
						when "00100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						when "00101" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0111";
							enable_o     <= "1010";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "00111" =>
							intern_o     <= '1';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							intern_o     <= '1';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							intern_o     <= '1';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							intern_o     <= '1';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							intern_o     <= '1';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							intern_o     <= '1';
						WHEN others =>
					end case;

				when x"56" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "0111";
							enable_o     <= "1010";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01001" =>
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "01011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"57" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
							end if;
						when "00010" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "0001";
								alu_mode_o   <= "1000";
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "0001";
								alu_mode_o   <= "1001";
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							end if;
						when "00011" =>
							if cflag_i = '0' then
								clocks_o     <= "1011";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1011";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
							end if;
						WHEN others =>
					end case;

				when x"58" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						when "00011" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							end if;
						when "00100" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "0010";
								alu_mode_o   <= "1000";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "0010";
								alu_mode_o   <= "1001";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							end if;
						when "00101" =>
							if cflag_i = '0' then
								clocks_o     <= "1011";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1011";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "00111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							end if;
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "01011" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							end if;
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "01111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							end if;
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "10011" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							end if;
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "10111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							end if;
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "11011" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							end if;
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "11111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							end if;
						WHEN others =>
					end case;

				when x"59" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							intern_o     <= '1';
						when "00100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						when "00101" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
								n_incpc_o    <= '0';
							end if;
						when "00110" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "0010";
								alu_mode_o   <= "1000";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "0010";
								alu_mode_o   <= "1001";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							end if;
						when "00111" =>
							if cflag_i = '0' then
								clocks_o     <= "1011";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1011";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							intern_o     <= '1';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							intern_o     <= '1';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							intern_o     <= '1';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							intern_o     <= '1';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							intern_o     <= '1';
						WHEN others =>
					end case;

				when x"5A" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
							end if;
						when "01000" =>
							if cflag_i = '0' then
								clocks_o     <= "1110";
								enable_o     <= "0010";
								alu_mode_o   <= "1000";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1110";
								enable_o     <= "0010";
								alu_mode_o   <= "1001";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							end if;
						when "01001" =>
							if cflag_i = '0' then
								clocks_o     <= "1011";
								enable_o     <= "1111";
								alu_mode_o   <= "1000";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1011";
								enable_o     <= "1111";
								alu_mode_o   <= "1001";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "01010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "01011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
							end if;
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
							end if;
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							if cflag_i = '0' then
								alu_mode_o   <= "1000";
								intern_o     <= '1';
								adrsel_o     <= '0';
							else
								alu_mode_o   <= "1001";
								intern_o     <= '1';
								adrsel_o     <= '0';
							end if;
						WHEN others =>
					end case;

				when x"5B" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						when "00011" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0111";
							enable_o     <= "1011";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "00101" =>
							intern_o     <= '1';
						WHEN "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "00111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "01011" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "01111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "10011" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "10111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "11011" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "11111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN others =>
					end case;

				when x"5C" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							intern_o     <= '1';
						when "00100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						when "00101" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0111";
							enable_o     <= "1011";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "00111" =>
							intern_o     <= '1';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							intern_o     <= '1';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							intern_o     <= '1';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							intern_o     <= '1';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							intern_o     <= '1';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							intern_o     <= '1';
						WHEN others =>
					end case;

				when x"5D" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "0111";
							enable_o     <= "1011";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01001" =>
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "01011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"5E" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						when "00011" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							adrsel_o     <= '0';
						when "00101" =>
							intern_o     <= '1';
						when "00110" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						when "00111" =>
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "01011" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "01111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "10011" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "10111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "11011" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "11111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN others =>
					end case;

				when x"5F" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1010";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "01000" =>
							clocks_o     <= "1011";
							enable_o     <= "0010";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01001" =>
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
						WHEN "01011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "01100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "01101" =>
							clocks_o     <= "1010";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "1010";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
						WHEN "11011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "11100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "1010";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN others =>
					end case;

				when x"60" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0101";
						when "00010" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00011" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						when "00100" =>
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0101";
						WHEN "00110" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00111" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0101";
						WHEN "01010" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01011" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0101";
						WHEN "01110" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0101";
						WHEN "10010" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10011" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0101";
						WHEN "10110" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0101";
						WHEN "11010" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11011" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0101";
						WHEN "11110" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN others =>
					end case;

				when x"61" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "00100" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "00101" =>
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN others =>
					end case;

				when x"62" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						when "00011" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "00111" =>
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN others =>
					end case;

				when x"63" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							n_mend_o     <= '0';
						when "00010" =>
							intern_o     <= '1';
						WHEN "00011" =>
							n_mend_o     <= '0';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							n_mend_o     <= '0';
						WHEN "00110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							n_mend_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							n_mend_o     <= '0';
						WHEN "01010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							n_mend_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							n_mend_o     <= '0';
						WHEN "01110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							n_mend_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							n_mend_o     <= '0';
						WHEN "10010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							n_mend_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							n_mend_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							n_mend_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							n_mend_o     <= '0';
						WHEN "11010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							n_mend_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							n_mend_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							n_mend_o     <= '0';
						WHEN others =>
					end case;

				when x"64" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0101";
						when "00010" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00011" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						when "00100" =>
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0101";
						WHEN "00110" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00111" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0101";
						WHEN "01010" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01011" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0101";
						WHEN "01110" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0101";
						WHEN "10010" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10011" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0101";
						WHEN "10110" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0101";
						WHEN "11010" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11011" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0101";
						WHEN "11110" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN others =>
					end case;

				when x"65" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "00100" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "00101" =>
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN others =>
					end case;

				when x"66" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						when "00011" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "00111" =>
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN others =>
					end case;

				when x"67" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							n_mend_o     <= '0';
						when "00010" =>
							intern_o     <= '1';
						WHEN "00011" =>
							n_mend_o     <= '0';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							n_mend_o     <= '0';
						WHEN "00110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							n_mend_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							n_mend_o     <= '0';
						WHEN "01010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							n_mend_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							n_mend_o     <= '0';
						WHEN "01110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							n_mend_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							n_mend_o     <= '0';
						WHEN "10010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							n_mend_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							n_mend_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							n_mend_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							n_mend_o     <= '0';
						WHEN "11010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							n_mend_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							n_mend_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							n_mend_o     <= '0';
						WHEN others =>
					end case;

				when x"68" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						when "00010" =>
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						when "00011" =>
							clocks_o     <= "1111";
							enable_o     <= "1010";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_mend_o     <= '0';
						when "00100" =>
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN "00110" =>
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						WHEN "00111" =>
							clocks_o     <= "1111";
							enable_o     <= "1010";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_mend_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN "01010" =>
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						WHEN "01011" =>
							clocks_o     <= "1111";
							enable_o     <= "1010";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_mend_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN "01110" =>
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1111";
							enable_o     <= "1010";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_mend_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN "10010" =>
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						WHEN "10011" =>
							clocks_o     <= "1111";
							enable_o     <= "1010";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_mend_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN "10110" =>
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1111";
							enable_o     <= "1010";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_mend_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN "11010" =>
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						WHEN "11011" =>
							clocks_o     <= "1111";
							enable_o     <= "1010";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_mend_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN "11110" =>
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1111";
							enable_o     <= "1010";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_mend_o     <= '0';
						WHEN others =>
					end case;

				when x"69" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						when "00010" =>
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						when "00011" =>
							clocks_o     <= "1111";
							enable_o     <= "1011";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_mend_o     <= '0';
						when "00100" =>
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN "00110" =>
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						WHEN "00111" =>
							clocks_o     <= "1111";
							enable_o     <= "1011";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_mend_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN "01010" =>
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						WHEN "01011" =>
							clocks_o     <= "1111";
							enable_o     <= "1011";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_mend_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN "01110" =>
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1111";
							enable_o     <= "1011";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_mend_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN "10010" =>
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						WHEN "10011" =>
							clocks_o     <= "1111";
							enable_o     <= "1011";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_mend_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN "10110" =>
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1111";
							enable_o     <= "1011";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_mend_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN "11010" =>
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						WHEN "11011" =>
							clocks_o     <= "1111";
							enable_o     <= "1011";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_mend_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN "11110" =>
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1111";
							enable_o     <= "1011";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_mend_o     <= '0';
						WHEN others =>
					end case;

				when x"6A" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0101";
						when "00010" =>
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						when "00011" =>
							clocks_o     <= "1111";
							enable_o     <= "1011";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_mend_o     <= '0';
						when "00100" =>
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0101";
						WHEN "00110" =>
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						WHEN "00111" =>
							clocks_o     <= "1111";
							enable_o     <= "1011";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_mend_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0101";
						WHEN "01010" =>
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						WHEN "01011" =>
							clocks_o     <= "1111";
							enable_o     <= "1011";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_mend_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0101";
						WHEN "01110" =>
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1111";
							enable_o     <= "1011";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_mend_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0101";
						WHEN "10010" =>
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						WHEN "10011" =>
							clocks_o     <= "1111";
							enable_o     <= "1011";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_mend_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0101";
						WHEN "10110" =>
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1111";
							enable_o     <= "1011";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_mend_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0101";
						WHEN "11010" =>
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						WHEN "11011" =>
							clocks_o     <= "1111";
							enable_o     <= "1011";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_mend_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0101";
						WHEN "11110" =>
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1111";
							enable_o     <= "1011";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_mend_o     <= '0';
						WHEN others =>
					end case;

				when x"6B" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						when "00010" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "00110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "01010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "01110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "10010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "11010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN others =>
					end case;

				when x"6C" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							intern_o     <= '1';
						when "00100" =>
							clocks_o     <= "1011";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						when "00101" =>
							intern_o     <= '1';
						WHEN "00110" =>
							clocks_o     <= "1010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							intern_o     <= '1';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "1010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "1010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							intern_o     <= '1';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							intern_o     <= '1';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "1010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							intern_o     <= '1';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							intern_o     <= '1';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "1010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							intern_o     <= '1';
						WHEN others =>
					end case;

				when x"6D" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							intern_o     <= '1';
						when "00101" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							alu_mode_o   <= "1110";
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01000" =>
							clocks_o     <= "1010";
							enable_o     <= "0010";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1101";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01011" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "01100" =>
							clocks_o     <= "1011";
							enable_o     <= "0010";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01101" =>
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							intern_o     <= '1';
						WHEN "10101" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							alu_mode_o   <= "1110";
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "11100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							intern_o     <= '1';
						WHEN "11101" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							alu_mode_o   <= "1110";
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN others =>
					end case;

				when x"6E" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							intern_o     <= '1';
						when "00101" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							alu_mode_o   <= "1110";
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01000" =>
							clocks_o     <= "0111";
							enable_o     <= "1010";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1101";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01011" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "01100" =>
							clocks_o     <= "0111";
							enable_o     <= "1011";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01101" =>
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							intern_o     <= '1';
						WHEN "10101" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							alu_mode_o   <= "1110";
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "11100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							intern_o     <= '1';
						WHEN "11101" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							alu_mode_o   <= "1110";
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN others =>
					end case;

				when x"6F" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "0111";
							enable_o     <= "1010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "01000" =>
							clocks_o     <= "0111";
							enable_o     <= "1011";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01001" =>
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
						WHEN "01011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "01100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "01101" =>
							clocks_o     <= "0111";
							enable_o     <= "1010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "0111";
							enable_o     <= "1010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
						WHEN "11011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "11100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "0111";
							enable_o     <= "1010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN others =>
					end case;

				when x"70" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						when "00010" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00011" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						when "00100" =>
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN "00110" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00111" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN "01010" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01011" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN "01110" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN "10010" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10011" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN "10110" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN "11010" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11011" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN "11110" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						WHEN others =>
					end case;

				when x"71" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "00100" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "00101" =>
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN others =>
					end case;

				when x"72" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						when "00011" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "00111" =>
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							alu_mode_o   <= "0101";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN others =>
					end case;

				when x"73" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1101";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						when "01100" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01110" =>
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "11100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"74" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1101";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						when "01100" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01110" =>
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "11100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"75" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						when "01000" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01010" =>
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN others =>
					end case;

				when x"76" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						when "01000" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01010" =>
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN others =>
					end case;

				when x"77" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							n_mend_o     <= '0';
						when "00010" =>
							intern_o     <= '1';
						WHEN "00011" =>
							n_mend_o     <= '0';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							n_mend_o     <= '0';
						WHEN "00110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							n_mend_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							n_mend_o     <= '0';
						WHEN "01010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							n_mend_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							n_mend_o     <= '0';
						WHEN "01110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							n_mend_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							n_mend_o     <= '0';
						WHEN "10010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							n_mend_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							n_mend_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							n_mend_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							n_mend_o     <= '0';
						WHEN "11010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							n_mend_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							n_mend_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							n_mend_o     <= '0';
						WHEN others =>
					end case;

				when x"78" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						when "01000" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01010" =>
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN others =>
					end case;

				when x"79" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						when "01000" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01010" =>
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
						WHEN others =>
					end case;

				when x"7A" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						when "00011" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00100" =>
							clocks_o     <= "0111";
							enable_o     <= "1001";
							alu_mode_o   <= "1111";
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							n_aluclk_o   <= '0';
						when "00110" =>
							clocks_o     <= "1110";
							enable_o     <= "1101";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00111" =>
							clocks_o     <= "0111";
							enable_o     <= "1010";
							alu_mode_o   <= "1111";
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "1110";
							enable_o     <= "1101";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01010" =>
							clocks_o     <= "0111";
							enable_o     <= "1011";
							alu_mode_o   <= "1111";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01011" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01100" =>
							clocks_o     <= "0111";
							enable_o     <= "1001";
							alu_mode_o   <= "1111";
							adrsel_o     <= '0';
						WHEN "01101" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							n_aluclk_o   <= '0';
						WHEN "01110" =>
							clocks_o     <= "1110";
							enable_o     <= "1101";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "01111" =>
							clocks_o     <= "0111";
							enable_o     <= "1010";
							alu_mode_o   <= "1111";
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						WHEN "10011" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0111";
							enable_o     <= "1001";
							alu_mode_o   <= "1111";
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							n_aluclk_o   <= '0';
						WHEN "10110" =>
							clocks_o     <= "1110";
							enable_o     <= "1101";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10111" =>
							clocks_o     <= "0111";
							enable_o     <= "1010";
							alu_mode_o   <= "1111";
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						WHEN "11011" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0111";
							enable_o     <= "1001";
							alu_mode_o   <= "1111";
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							n_aluclk_o   <= '0';
						WHEN "11110" =>
							clocks_o     <= "1110";
							enable_o     <= "1101";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11111" =>
							clocks_o     <= "0111";
							enable_o     <= "1010";
							alu_mode_o   <= "1111";
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"7B" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						when "00010" =>
							clocks_o     <= "1010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00011" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "00110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "01010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "01110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "10010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "11010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN others =>
					end case;

				when x"7C" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						when "00011" =>
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00101" =>
							alu_mode_o   <= "1110";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "00110" =>
							clocks_o     <= "0111";
							enable_o     <= "1101";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "00111" =>
							intern_o     <= '1';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "01011" =>
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "01111" =>
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "10011" =>
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "10111" =>
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "11011" =>
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "11111" =>
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN others =>
					end case;

				when x"7D" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							intern_o     <= '1';
						when "00100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						when "00101" =>
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00111" =>
							alu_mode_o   <= "1110";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01000" =>
							clocks_o     <= "0111";
							enable_o     <= "1101";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01001" =>
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						WHEN "01101" =>
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "01111" =>
							alu_mode_o   <= "1110";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							intern_o     <= '1';
						WHEN "10100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						WHEN "10101" =>
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10111" =>
							alu_mode_o   <= "1110";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							intern_o     <= '1';
						WHEN "11100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						WHEN "11101" =>
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "11111" =>
							alu_mode_o   <= "1110";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN others =>
					end case;

				when x"7E" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "01001" =>
							alu_mode_o   <= "1110";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01010" =>
							clocks_o     <= "0111";
							enable_o     <= "1101";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01011" =>
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"7F" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "01001" =>
							alu_mode_o   <= "1110";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01010" =>
							clocks_o     <= "0111";
							enable_o     <= "1101";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01011" =>
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"80" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0011";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						when "00011" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0011";
							intern_o     <= '1';
						WHEN others =>
					end case;

				when x"81" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00100" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "00101" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"82" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						when "00100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						when "00101" =>
							alu_mode_o   <= "0011";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "00111" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN others =>
					end case;

				when x"83" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1101";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01100" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01101" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "11100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"84" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1101";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01100" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01101" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "11100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"85" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01001" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "01011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"86" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01001" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "01011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"87" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							n_mend_o     <= '0';
						when "00010" =>
							intern_o     <= '1';
						WHEN "00011" =>
							n_mend_o     <= '0';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							n_mend_o     <= '0';
						WHEN "00110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							n_mend_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							n_mend_o     <= '0';
						WHEN "01010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							n_mend_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							n_mend_o     <= '0';
						WHEN "01110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							n_mend_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							n_mend_o     <= '0';
						WHEN "10010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							n_mend_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							n_mend_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							n_mend_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							n_mend_o     <= '0';
						WHEN "11010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							n_mend_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							n_mend_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							n_mend_o     <= '0';
						WHEN others =>
					end case;

				when x"88" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01001" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "01011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"89" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01001" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "01011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"8A" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							alu_mode_o   <= "1110";
							const_01_o   <= '1';
						when "00010" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1101";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1011";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1101";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1010";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "01010" =>
							clocks_o     <= "1000";
							enable_o     <= "1101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01011" =>
							clocks_o     <= "1001";
							enable_o     <= "0010";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01100" =>
							intern_o     <= '1';
						WHEN "01101" =>
							intern_o     <= '1';
						WHEN "01110" =>
							intern_o     <= '1';
						WHEN "01111" =>
							intern_o     <= '1';
						WHEN "10000" =>
							intern_o     <= '1';
						WHEN "10001" =>
							intern_o     <= '1';
						WHEN "10010" =>
							intern_o     <= '1';
						WHEN "10011" =>
							intern_o     <= '1';
						WHEN "10100" =>
							intern_o     <= '1';
						WHEN "10101" =>
							intern_o     <= '1';
						WHEN "10110" =>
							intern_o     <= '1';
						WHEN "10111" =>
							intern_o     <= '1';
						WHEN "11000" =>
							intern_o     <= '1';
						WHEN "11001" =>
							intern_o     <= '1';
						WHEN "11010" =>
							intern_o     <= '1';
						WHEN "11011" =>
							intern_o     <= '1';
						WHEN "11100" =>
							intern_o     <= '1';
						WHEN "11101" =>
							intern_o     <= '1';
						WHEN "11110" =>
							intern_o     <= '1';
						WHEN "11111" =>
							intern_o     <= '1';
						WHEN others =>
					end case;

				when x"8B" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						when "00010" =>
							clocks_o     <= "1011";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00011" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "00110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "01010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "01110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "10010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "11010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1110";
							n_mend_o     <= '0';
						WHEN others =>
					end case;

				when x"8C" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						when "00011" =>
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1111";
							adrsel_o     <= '0';
						when "00101" =>
							alu_mode_o   <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "00110" =>
							clocks_o     <= "0111";
							enable_o     <= "1101";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "00111" =>
							intern_o     <= '1';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "01011" =>
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "01111" =>
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "10011" =>
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "10111" =>
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "11011" =>
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "11111" =>
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN others =>
					end case;

				when x"8D" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							intern_o     <= '1';
						when "00100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						when "00101" =>
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1111";
							adrsel_o     <= '0';
						when "00111" =>
							alu_mode_o   <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01000" =>
							clocks_o     <= "0111";
							enable_o     <= "1101";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01001" =>
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						WHEN "01101" =>
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1111";
							adrsel_o     <= '0';
						WHEN "01111" =>
							alu_mode_o   <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							intern_o     <= '1';
						WHEN "10100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						WHEN "10101" =>
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1111";
							adrsel_o     <= '0';
						WHEN "10111" =>
							alu_mode_o   <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							intern_o     <= '1';
						WHEN "11100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						WHEN "11101" =>
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1111";
							adrsel_o     <= '0';
						WHEN "11111" =>
							alu_mode_o   <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN others =>
					end case;

				when x"8E" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1111";
							adrsel_o     <= '0';
						when "01001" =>
							alu_mode_o   <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01010" =>
							clocks_o     <= "0111";
							enable_o     <= "1101";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01011" =>
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"8F" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1111";
							adrsel_o     <= '0';
						when "01001" =>
							alu_mode_o   <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01010" =>
							clocks_o     <= "0111";
							enable_o     <= "1101";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01011" =>
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"90" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0100";
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						when "00011" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0100";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							intern_o     <= '1';
						WHEN others =>
					end case;

				when x"91" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00100" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0100";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "00101" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0100";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"92" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						when "00100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						when "00101" =>
							alu_mode_o   <= "0100";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0100";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "00111" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0100";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN others =>
					end case;

				when x"93" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1101";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01100" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0100";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01101" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0100";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "11100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"94" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1101";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01100" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0100";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01101" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0100";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "11100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"95" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0100";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01001" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0100";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "01011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"96" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0100";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01001" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0100";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "01011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"97" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							n_mend_o     <= '0';
						when "00010" =>
							intern_o     <= '1';
						WHEN "00011" =>
							n_mend_o     <= '0';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							n_mend_o     <= '0';
						WHEN "00110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							n_mend_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							n_mend_o     <= '0';
						WHEN "01010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							n_mend_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							n_mend_o     <= '0';
						WHEN "01110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							n_mend_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							n_mend_o     <= '0';
						WHEN "10010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							n_mend_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							n_mend_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							n_mend_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							n_mend_o     <= '0';
						WHEN "11010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							n_mend_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							n_mend_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							n_mend_o     <= '0';
						WHEN others =>
					end case;

				when x"98" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0100";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01001" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0100";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "01011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"99" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0100";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01001" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0100";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "01011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"9A" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						when "00011" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "1100";
							enable_o     <= "0010";
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "0111";
							enable_o     <= "1100";
							alu_mode_o   <= "1111";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01001" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "01011" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "1100";
							enable_o     <= "0010";
							adrsel_o     <= '0';
						WHEN "01101" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "10011" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "1100";
							enable_o     <= "0010";
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "11011" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "1100";
							enable_o     <= "0010";
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"9B" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						when "00010" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "00110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "01010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "01110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "10010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "11010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN others =>
					end case;

				when x"9C" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1101";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01011" =>
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01100" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "01101" =>
							alu_mode_o   <= "1110";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01110" =>
							clocks_o     <= "0111";
							enable_o     <= "1101";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01111" =>
							intern_o     <= '1';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "11100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"9D" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1101";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01011" =>
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01100" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "01101" =>
							alu_mode_o   <= "1110";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01110" =>
							clocks_o     <= "0111";
							enable_o     <= "1101";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01111" =>
							intern_o     <= '1';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "11100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"9E" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1101";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01011" =>
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01100" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1111";
							adrsel_o     <= '0';
						when "01101" =>
							alu_mode_o   <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01110" =>
							clocks_o     <= "0111";
							enable_o     <= "1101";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01111" =>
							intern_o     <= '1';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "11100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"9F" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1101";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01011" =>
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01100" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1111";
							adrsel_o     <= '0';
						when "01101" =>
							alu_mode_o   <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01110" =>
							clocks_o     <= "0111";
							enable_o     <= "1101";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01111" =>
							intern_o     <= '1';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "11100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"A0" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						when "00010" =>
							if cflag_i = '0' then
								clocks_o     <= "1111";
								enable_o     <= "0001";
								alu_mode_o   <= "0101";
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1111";
								enable_o     <= "0001";
								alu_mode_o   <= "0101";
								n_incpc_o    <= '0';
							end if;
						when "00011" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								n_aluclk_o   <= '0';
							end if;
						when "00100" =>
							if cflag_i = '0' then
								intern_o     <= '1';
							else
								alu_mode_o   <= "0110";
								n_mend_o     <= '0';
							end if;
						when "00101" =>
							if cflag_i = '0' then
								intern_o     <= '1';
							else
								clocks_o     <= "1010";
								enable_o     <= "1111";
								alu_mode_o   <= "0110";
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "00110" =>
							if cflag_i = '0' then
								clocks_o     <= "1111";
								enable_o     <= "0001";
								alu_mode_o   <= "0101";
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1111";
								enable_o     <= "0001";
								alu_mode_o   <= "0101";
								n_incpc_o    <= '0';
							end if;
						WHEN "00111" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								n_aluclk_o   <= '0';
							end if;
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "01010" =>
							if cflag_i = '0' then
								clocks_o     <= "1111";
								enable_o     <= "0001";
								alu_mode_o   <= "0101";
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1111";
								enable_o     <= "0001";
								alu_mode_o   <= "0101";
								n_incpc_o    <= '0';
							end if;
						WHEN "01011" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								n_aluclk_o   <= '0';
							end if;
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "01110" =>
							if cflag_i = '0' then
								clocks_o     <= "1111";
								enable_o     <= "0001";
								alu_mode_o   <= "0101";
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1111";
								enable_o     <= "0001";
								alu_mode_o   <= "0101";
								n_incpc_o    <= '0';
							end if;
						WHEN "01111" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								n_aluclk_o   <= '0';
							end if;
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							if cflag_i = '0' then
								clocks_o     <= "1111";
								enable_o     <= "0001";
								alu_mode_o   <= "0101";
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1111";
								enable_o     <= "0001";
								alu_mode_o   <= "0101";
								n_incpc_o    <= '0';
							end if;
						WHEN "10011" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								n_aluclk_o   <= '0';
							end if;
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "10110" =>
							if cflag_i = '0' then
								clocks_o     <= "1111";
								enable_o     <= "0001";
								alu_mode_o   <= "0101";
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1111";
								enable_o     <= "0001";
								alu_mode_o   <= "0101";
								n_incpc_o    <= '0';
							end if;
						WHEN "10111" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								n_aluclk_o   <= '0';
							end if;
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							if cflag_i = '0' then
								clocks_o     <= "1111";
								enable_o     <= "0001";
								alu_mode_o   <= "0101";
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1111";
								enable_o     <= "0001";
								alu_mode_o   <= "0101";
								n_incpc_o    <= '0';
							end if;
						WHEN "11011" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								n_aluclk_o   <= '0';
							end if;
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
						WHEN "11110" =>
							if cflag_i = '0' then
								clocks_o     <= "1111";
								enable_o     <= "0001";
								alu_mode_o   <= "0101";
								n_incpc_o    <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1111";
								enable_o     <= "0001";
								alu_mode_o   <= "0101";
								n_incpc_o    <= '0';
							end if;
						WHEN "11111" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								n_aluclk_o   <= '0';
							end if;
						WHEN others =>
					end case;

				when x"A1" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00100" =>
							if cflag_i = '0' then
								clocks_o     <= "1111";
								enable_o     <= "0010";
								alu_mode_o   <= "0101";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1111";
								enable_o     <= "0010";
								alu_mode_o   <= "0101";
								adrsel_o     <= '0';
							end if;
						when "00101" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								n_aluclk_o   <= '0';
							end if;
						when "00110" =>
							if cflag_i = '0' then
								intern_o     <= '1';
							else
								alu_mode_o   <= "0110";
								n_mend_o     <= '0';
							end if;
						when "00111" =>
							if cflag_i = '0' then
								intern_o     <= '1';
							else
								clocks_o     <= "1010";
								enable_o     <= "1111";
								alu_mode_o   <= "0110";
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"A2" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						when "00100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						when "00101" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "00110" =>
							if cflag_i = '0' then
								clocks_o     <= "1111";
								enable_o     <= "0010";
								alu_mode_o   <= "0101";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1111";
								enable_o     <= "0010";
								alu_mode_o   <= "0101";
								adrsel_o     <= '0';
							end if;
						when "00111" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								n_aluclk_o   <= '0';
							end if;
						when "01000" =>
							if cflag_i = '0' then
								intern_o     <= '1';
							else
								alu_mode_o   <= "0110";
								n_mend_o     <= '0';
							end if;
						when "01001" =>
							if cflag_i = '0' then
								intern_o     <= '1';
							else
								clocks_o     <= "1010";
								enable_o     <= "1111";
								alu_mode_o   <= "0110";
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						WHEN "01101" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							if cflag_i = '0' then
								clocks_o     <= "1111";
								enable_o     <= "0010";
								alu_mode_o   <= "0101";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1111";
								enable_o     <= "0010";
								alu_mode_o   <= "0101";
								adrsel_o     <= '0';
							end if;
						WHEN "01111" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								n_aluclk_o   <= '0';
							end if;
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN "10100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						WHEN "10101" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							if cflag_i = '0' then
								clocks_o     <= "1111";
								enable_o     <= "0010";
								alu_mode_o   <= "0101";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1111";
								enable_o     <= "0010";
								alu_mode_o   <= "0101";
								adrsel_o     <= '0';
							end if;
						WHEN "10111" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								n_aluclk_o   <= '0';
							end if;
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN "11100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						WHEN "11101" =>
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							if cflag_i = '0' then
								clocks_o     <= "1111";
								enable_o     <= "0010";
								alu_mode_o   <= "0101";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1111";
								enable_o     <= "0010";
								alu_mode_o   <= "0101";
								adrsel_o     <= '0';
							end if;
						WHEN "11111" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								n_aluclk_o   <= '0';
							end if;
						WHEN others =>
					end case;

				when x"A3" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1101";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01100" =>
							if cflag_i = '0' then
								clocks_o     <= "1111";
								enable_o     <= "0010";
								alu_mode_o   <= "0101";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1111";
								enable_o     <= "0010";
								alu_mode_o   <= "0101";
								adrsel_o     <= '0';
							end if;
						when "01101" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								n_aluclk_o   <= '0';
							end if;
						when "01110" =>
							if cflag_i = '0' then
								intern_o     <= '1';
							else
								alu_mode_o   <= "0110";
								n_mend_o     <= '0';
							end if;
						when "01111" =>
							if cflag_i = '0' then
								intern_o     <= '1';
							else
								clocks_o     <= "1010";
								enable_o     <= "1111";
								alu_mode_o   <= "0110";
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "11100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"A4" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1101";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01100" =>
							if cflag_i = '0' then
								clocks_o     <= "1111";
								enable_o     <= "0010";
								alu_mode_o   <= "0101";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1111";
								enable_o     <= "0010";
								alu_mode_o   <= "0101";
								adrsel_o     <= '0';
							end if;
						when "01101" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								n_aluclk_o   <= '0';
							end if;
						when "01110" =>
							if cflag_i = '0' then
								intern_o     <= '1';
							else
								alu_mode_o   <= "0110";
								n_mend_o     <= '0';
							end if;
						when "01111" =>
							if cflag_i = '0' then
								intern_o     <= '1';
							else
								clocks_o     <= "1010";
								enable_o     <= "1111";
								alu_mode_o   <= "0110";
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "11100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"A5" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							if cflag_i = '0' then
								clocks_o     <= "1111";
								enable_o     <= "0010";
								alu_mode_o   <= "0101";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1111";
								enable_o     <= "0010";
								alu_mode_o   <= "0101";
								adrsel_o     <= '0';
							end if;
						when "01001" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								n_aluclk_o   <= '0';
							end if;
						when "01010" =>
							if cflag_i = '0' then
								intern_o     <= '1';
							else
								alu_mode_o   <= "0110";
								n_mend_o     <= '0';
							end if;
						when "01011" =>
							if cflag_i = '0' then
								intern_o     <= '1';
							else
								clocks_o     <= "1010";
								enable_o     <= "1111";
								alu_mode_o   <= "0110";
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"A6" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							if cflag_i = '0' then
								clocks_o     <= "1111";
								enable_o     <= "0010";
								alu_mode_o   <= "0101";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1111";
								enable_o     <= "0010";
								alu_mode_o   <= "0101";
								adrsel_o     <= '0';
							end if;
						when "01001" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								n_aluclk_o   <= '0';
							end if;
						when "01010" =>
							if cflag_i = '0' then
								intern_o     <= '1';
							else
								alu_mode_o   <= "0110";
								n_mend_o     <= '0';
							end if;
						when "01011" =>
							if cflag_i = '0' then
								intern_o     <= '1';
							else
								clocks_o     <= "1010";
								enable_o     <= "1111";
								alu_mode_o   <= "0110";
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"A7" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							n_mend_o     <= '0';
						when "00010" =>
							intern_o     <= '1';
						WHEN "00011" =>
							n_mend_o     <= '0';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							n_mend_o     <= '0';
						WHEN "00110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							n_mend_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							n_mend_o     <= '0';
						WHEN "01010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							n_mend_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							n_mend_o     <= '0';
						WHEN "01110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							n_mend_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							n_mend_o     <= '0';
						WHEN "10010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							n_mend_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							n_mend_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							n_mend_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							n_mend_o     <= '0';
						WHEN "11010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							n_mend_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							n_mend_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							n_mend_o     <= '0';
						WHEN others =>
					end case;

				when x"A8" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							if cflag_i = '0' then
								clocks_o     <= "1111";
								enable_o     <= "0001";
								alu_mode_o   <= "0101";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1111";
								enable_o     <= "0001";
								alu_mode_o   <= "0101";
								adrsel_o     <= '0';
							end if;
						when "01001" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								n_aluclk_o   <= '0';
							end if;
						when "01010" =>
							if cflag_i = '0' then
								intern_o     <= '1';
							else
								alu_mode_o   <= "0110";
								n_mend_o     <= '0';
							end if;
						when "01011" =>
							if cflag_i = '0' then
								intern_o     <= '1';
							else
								clocks_o     <= "1010";
								enable_o     <= "1111";
								alu_mode_o   <= "0110";
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"A9" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							if cflag_i = '0' then
								clocks_o     <= "1111";
								enable_o     <= "0001";
								alu_mode_o   <= "0101";
								adrsel_o     <= '0';
								n_mend_o     <= '0';
							else
								clocks_o     <= "1111";
								enable_o     <= "0001";
								alu_mode_o   <= "0101";
								adrsel_o     <= '0';
							end if;
						when "01001" =>
							if cflag_i = '0' then
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							else
								clocks_o     <= "1001";
								enable_o     <= "1111";
								alu_mode_o   <= "0101";
								n_alu_ldvz_o <= '0';
								n_aluclk_o   <= '0';
							end if;
						when "01010" =>
							if cflag_i = '0' then
								intern_o     <= '1';
							else
								alu_mode_o   <= "0110";
								n_mend_o     <= '0';
							end if;
						when "01011" =>
							if cflag_i = '0' then
								intern_o     <= '1';
							else
								clocks_o     <= "1010";
								enable_o     <= "1111";
								alu_mode_o   <= "0110";
								intern_o     <= '1';
								n_aluclk_o   <= '0';
							end if;
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"AA" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00011" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						when "00100" =>
							clocks_o     <= "1000";
							enable_o     <= "1101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1100";
							enable_o     <= "0010";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00111" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						when "01000" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "01001" =>
							clocks_o     <= "0111";
							enable_o     <= "1100";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01010" =>
							intern_o     <= '1';
						WHEN "01011" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "01100" =>
							clocks_o     <= "1000";
							enable_o     <= "1101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "01101" =>
							clocks_o     <= "1100";
							enable_o     <= "0010";
							adrsel_o     <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01111" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10011" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "10100" =>
							clocks_o     <= "1000";
							enable_o     <= "1101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "1100";
							enable_o     <= "0010";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10111" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1110";
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11011" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "11100" =>
							clocks_o     <= "1000";
							enable_o     <= "1101";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "1100";
							enable_o     <= "0010";
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11111" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN others =>
					end case;

				when x"AB" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						when "00010" =>
							clocks_o     <= "1010";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00011" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "00110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "01010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "01110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "10010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "11010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN others =>
					end case;

				when x"AC" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						when "00011" =>
							alu_mode_o   <= "1010";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1010";
							adrsel_o     <= '0';
						when "00101" =>
							alu_mode_o   <= "1010";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "00110" =>
							clocks_o     <= "0111";
							enable_o     <= "1101";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "00111" =>
							intern_o     <= '1';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "01011" =>
							alu_mode_o   <= "1010";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "01111" =>
							alu_mode_o   <= "1010";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "10011" =>
							alu_mode_o   <= "1010";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "10111" =>
							alu_mode_o   <= "1010";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "11011" =>
							alu_mode_o   <= "1010";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "11111" =>
							alu_mode_o   <= "1010";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN others =>
					end case;

				when x"AD" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							intern_o     <= '1';
						when "00100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						when "00101" =>
							alu_mode_o   <= "1010";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1010";
							adrsel_o     <= '0';
						when "00111" =>
							alu_mode_o   <= "1010";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01000" =>
							clocks_o     <= "0111";
							enable_o     <= "1101";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01001" =>
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						WHEN "01101" =>
							alu_mode_o   <= "1010";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1010";
							adrsel_o     <= '0';
						WHEN "01111" =>
							alu_mode_o   <= "1010";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							intern_o     <= '1';
						WHEN "10100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						WHEN "10101" =>
							alu_mode_o   <= "1010";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1010";
							adrsel_o     <= '0';
						WHEN "10111" =>
							alu_mode_o   <= "1010";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							intern_o     <= '1';
						WHEN "11100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						WHEN "11101" =>
							alu_mode_o   <= "1010";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1010";
							adrsel_o     <= '0';
						WHEN "11111" =>
							alu_mode_o   <= "1010";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN others =>
					end case;

				when x"AE" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							alu_mode_o   <= "1010";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1010";
							adrsel_o     <= '0';
						when "01001" =>
							alu_mode_o   <= "1010";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01010" =>
							clocks_o     <= "0111";
							enable_o     <= "1101";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01011" =>
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							alu_mode_o   <= "1010";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							alu_mode_o   <= "1010";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							alu_mode_o   <= "1010";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"AF" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							alu_mode_o   <= "1010";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1010";
							adrsel_o     <= '0';
						when "01001" =>
							alu_mode_o   <= "1010";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01010" =>
							clocks_o     <= "0111";
							enable_o     <= "1101";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01011" =>
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							alu_mode_o   <= "1010";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							alu_mode_o   <= "1010";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							alu_mode_o   <= "1010";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"B0" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0111";
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						when "00011" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
						WHEN others =>
					end case;

				when x"B1" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00100" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0111";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "00101" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"B2" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						when "00100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						when "00101" =>
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0111";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "00111" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN others =>
					end case;

				when x"B3" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1101";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01100" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0111";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01101" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "11100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"B4" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1101";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01100" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0111";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01101" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "11100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"B5" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0111";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01001" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "01011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"B6" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0111";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01001" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "01011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"B7" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							n_mend_o     <= '0';
						when "00010" =>
							intern_o     <= '1';
						WHEN "00011" =>
							n_mend_o     <= '0';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							n_mend_o     <= '0';
						WHEN "00110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							n_mend_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							n_mend_o     <= '0';
						WHEN "01010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							n_mend_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							n_mend_o     <= '0';
						WHEN "01110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							n_mend_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							n_mend_o     <= '0';
						WHEN "10010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							n_mend_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							n_mend_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							n_mend_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							n_mend_o     <= '0';
						WHEN "11010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							n_mend_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							n_mend_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							n_mend_o     <= '0';
						WHEN others =>
					end case;

				when x"B8" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0111";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01001" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "01011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"B9" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0111";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01001" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "01011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"BA" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
						when "00011" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "00101" =>
							clocks_o     <= "0111";
							enable_o     <= "1100";
							alu_mode_o   <= "1111";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "00110" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00111" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
						WHEN "01011" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
						WHEN "01111" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
						WHEN "10011" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
						WHEN "10111" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
						WHEN "11011" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
						WHEN "11111" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
						WHEN others =>
					end case;

				when x"BB" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						when "00010" =>
							clocks_o     <= "1011";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00011" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "00110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "01010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "01110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "10010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "11010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "1111";
							n_mend_o     <= '0';
						WHEN others =>
					end case;

				when x"BC" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						when "00011" =>
							alu_mode_o   <= "1011";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1011";
							adrsel_o     <= '0';
						when "00101" =>
							alu_mode_o   <= "1011";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "00110" =>
							clocks_o     <= "0111";
							enable_o     <= "1101";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "00111" =>
							intern_o     <= '1';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "01011" =>
							alu_mode_o   <= "1011";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "01111" =>
							alu_mode_o   <= "1011";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "10011" =>
							alu_mode_o   <= "1011";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "10111" =>
							alu_mode_o   <= "1011";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "11011" =>
							alu_mode_o   <= "1011";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "11111" =>
							alu_mode_o   <= "1011";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN others =>
					end case;

				when x"BD" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							intern_o     <= '1';
						when "00100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						when "00101" =>
							alu_mode_o   <= "1011";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1011";
							adrsel_o     <= '0';
						when "00111" =>
							alu_mode_o   <= "1011";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01000" =>
							clocks_o     <= "0111";
							enable_o     <= "1101";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01001" =>
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						WHEN "01101" =>
							alu_mode_o   <= "1011";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1011";
							adrsel_o     <= '0';
						WHEN "01111" =>
							alu_mode_o   <= "1011";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							intern_o     <= '1';
						WHEN "10100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						WHEN "10101" =>
							alu_mode_o   <= "1011";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1011";
							adrsel_o     <= '0';
						WHEN "10111" =>
							alu_mode_o   <= "1011";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							intern_o     <= '1';
						WHEN "11100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						WHEN "11101" =>
							alu_mode_o   <= "1011";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1011";
							adrsel_o     <= '0';
						WHEN "11111" =>
							alu_mode_o   <= "1011";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN others =>
					end case;

				when x"BE" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							alu_mode_o   <= "1011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1011";
							adrsel_o     <= '0';
						when "01001" =>
							alu_mode_o   <= "1011";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01010" =>
							clocks_o     <= "0111";
							enable_o     <= "1101";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01011" =>
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							alu_mode_o   <= "1011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							alu_mode_o   <= "1011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							alu_mode_o   <= "1011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"BF" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							alu_mode_o   <= "1011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1011";
							adrsel_o     <= '0';
						when "01001" =>
							alu_mode_o   <= "1011";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01010" =>
							clocks_o     <= "0111";
							enable_o     <= "1101";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01011" =>
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							alu_mode_o   <= "1011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							alu_mode_o   <= "1011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							alu_mode_o   <= "1011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"C0" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0111";
						when "00011" =>
							alu_mode_o   <= "0111";
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1101";
							alu_mode_o   <= "0101";
						when "00101" =>
							clocks_o     <= "1111";
							enable_o     <= "1111";
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						when "00110" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_mend_o     <= '0';
						when "00111" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0111";
						WHEN "01011" =>
							alu_mode_o   <= "0111";
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0111";
						WHEN "01111" =>
							alu_mode_o   <= "0111";
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0111";
						WHEN "10011" =>
							alu_mode_o   <= "0111";
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0111";
						WHEN "10111" =>
							alu_mode_o   <= "0111";
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0111";
						WHEN "11011" =>
							alu_mode_o   <= "0111";
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0111";
						WHEN "11111" =>
							alu_mode_o   <= "0111";
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN others =>
					end case;

				when x"C1" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						when "00011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00100" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0111";
							adrsel_o     <= '0';
						when "00101" =>
							alu_mode_o   <= "0111";
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "1110";
							enable_o     <= "1101";
							alu_mode_o   <= "0101";
						when "00111" =>
							clocks_o     <= "1111";
							enable_o     <= "1111";
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_mend_o     <= '0';
						when "01001" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0111";
							adrsel_o     <= '0';
						WHEN "01101" =>
							alu_mode_o   <= "0111";
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "1110";
							enable_o     <= "1101";
							alu_mode_o   <= "0101";
						WHEN "01111" =>
							clocks_o     <= "1111";
							enable_o     <= "1111";
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "10011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0111";
							adrsel_o     <= '0';
						WHEN "10101" =>
							alu_mode_o   <= "0111";
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "1110";
							enable_o     <= "1101";
							alu_mode_o   <= "0101";
						WHEN "10111" =>
							clocks_o     <= "1111";
							enable_o     <= "1111";
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "11011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0111";
							adrsel_o     <= '0';
						WHEN "11101" =>
							alu_mode_o   <= "0111";
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "1110";
							enable_o     <= "1101";
							alu_mode_o   <= "0101";
						WHEN "11111" =>
							clocks_o     <= "1111";
							enable_o     <= "1111";
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						WHEN others =>
					end case;

				when x"C2" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						when "00100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						when "00101" =>
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0111";
							adrsel_o     <= '0';
						when "00111" =>
							alu_mode_o   <= "0111";
							n_aluclk_o   <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "1101";
							alu_mode_o   <= "0101";
						when "01001" =>
							clocks_o     <= "1111";
							enable_o     <= "1111";
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						when "01010" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_mend_o     <= '0';
						when "01011" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						WHEN "01101" =>
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0111";
							adrsel_o     <= '0';
						WHEN "01111" =>
							alu_mode_o   <= "0111";
							n_aluclk_o   <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN "10100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						WHEN "10101" =>
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0111";
							adrsel_o     <= '0';
						WHEN "10111" =>
							alu_mode_o   <= "0111";
							n_aluclk_o   <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN "11100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						WHEN "11101" =>
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0111";
							adrsel_o     <= '0';
						WHEN "11111" =>
							alu_mode_o   <= "0111";
							n_aluclk_o   <= '0';
						WHEN others =>
					end case;

				when x"C3" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1101";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01100" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0111";
							adrsel_o     <= '0';
						when "01101" =>
							alu_mode_o   <= "0111";
							n_aluclk_o   <= '0';
						when "01110" =>
							clocks_o     <= "1110";
							enable_o     <= "1101";
							alu_mode_o   <= "0101";
						when "01111" =>
							clocks_o     <= "1111";
							enable_o     <= "1111";
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						when "10000" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_mend_o     <= '0';
						when "10001" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "11001" =>
							clocks_o     <= "0010";
							enable_o     <= "1101";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						WHEN "11010" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0111";
							adrsel_o     <= '0';
						WHEN "11101" =>
							alu_mode_o   <= "0111";
							n_aluclk_o   <= '0';
						WHEN "11110" =>
							clocks_o     <= "1110";
							enable_o     <= "1101";
							alu_mode_o   <= "0101";
						WHEN "11111" =>
							clocks_o     <= "1111";
							enable_o     <= "1111";
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						WHEN others =>
					end case;

				when x"C4" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1101";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01100" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0111";
							adrsel_o     <= '0';
						when "01101" =>
							alu_mode_o   <= "0111";
							n_aluclk_o   <= '0';
						when "01110" =>
							clocks_o     <= "1110";
							enable_o     <= "1101";
							alu_mode_o   <= "0101";
						when "01111" =>
							clocks_o     <= "1111";
							enable_o     <= "1111";
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						when "10000" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_mend_o     <= '0';
						when "10001" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "11001" =>
							clocks_o     <= "0010";
							enable_o     <= "1101";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						WHEN "11010" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0111";
							adrsel_o     <= '0';
						WHEN "11101" =>
							alu_mode_o   <= "0111";
							n_aluclk_o   <= '0';
						WHEN "11110" =>
							clocks_o     <= "1110";
							enable_o     <= "1101";
							alu_mode_o   <= "0101";
						WHEN "11111" =>
							clocks_o     <= "1111";
							enable_o     <= "1111";
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						WHEN others =>
					end case;

				when x"C5" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0111";
							adrsel_o     <= '0';
						when "01001" =>
							alu_mode_o   <= "0111";
							n_aluclk_o   <= '0';
						when "01010" =>
							clocks_o     <= "1110";
							enable_o     <= "1101";
							alu_mode_o   <= "0101";
						when "01011" =>
							clocks_o     <= "1111";
							enable_o     <= "1111";
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						when "01100" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_mend_o     <= '0';
						when "01101" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"C6" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0111";
							adrsel_o     <= '0';
						when "01001" =>
							alu_mode_o   <= "0111";
							n_aluclk_o   <= '0';
						when "01010" =>
							clocks_o     <= "1110";
							enable_o     <= "1101";
							alu_mode_o   <= "0101";
						when "01011" =>
							clocks_o     <= "1111";
							enable_o     <= "1111";
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						when "01100" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_mend_o     <= '0';
						when "01101" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"C7" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							n_mend_o     <= '0';
						when "00010" =>
							intern_o     <= '1';
						WHEN "00011" =>
							n_mend_o     <= '0';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							n_mend_o     <= '0';
						WHEN "00110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							n_mend_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							n_mend_o     <= '0';
						WHEN "01010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							n_mend_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							n_mend_o     <= '0';
						WHEN "01110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							n_mend_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							n_mend_o     <= '0';
						WHEN "10010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							n_mend_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							n_mend_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							n_mend_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							n_mend_o     <= '0';
						WHEN "11010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							n_mend_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							n_mend_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							n_mend_o     <= '0';
						WHEN others =>
					end case;

				when x"C8" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0111";
							adrsel_o     <= '0';
						when "01001" =>
							alu_mode_o   <= "0111";
							n_aluclk_o   <= '0';
						when "01010" =>
							clocks_o     <= "1110";
							enable_o     <= "1101";
							alu_mode_o   <= "0101";
						when "01011" =>
							clocks_o     <= "1111";
							enable_o     <= "1111";
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						when "01100" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_mend_o     <= '0';
						when "01101" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"C9" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0111";
							adrsel_o     <= '0';
						when "01001" =>
							alu_mode_o   <= "0111";
							n_aluclk_o   <= '0';
						when "01010" =>
							clocks_o     <= "1110";
							enable_o     <= "1101";
							alu_mode_o   <= "0101";
						when "01011" =>
							clocks_o     <= "1111";
							enable_o     <= "1111";
							alu_mode_o   <= "0101";
							n_aluclk_o   <= '0';
						when "01100" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_mend_o     <= '0';
						when "01101" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0100";
							alu_csel_o   <= '1';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"CA" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							const_01_o   <= '1';
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1000";
							intern_o     <= '1';
						when "00100" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0111";
							enable_o     <= "1100";
							alu_mode_o   <= "1111";
							adrsel_o     <= '0';
						when "00111" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							n_aluclk_o   <= '0';
						when "01000" =>
							clocks_o     <= "1000";
							enable_o     <= "1101";
							alu_mode_o   <= "0001";
						when "01001" =>
							clocks_o     <= "1110";
							enable_o     <= "0101";
							alu_mode_o   <= "0001";
						when "01010" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							alu_mode_o   <= "0001";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01011" =>
							clocks_o     <= "0111";
							enable_o     <= "1101";
							alu_mode_o   <= "1111";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01100" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01110" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10000" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10001" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10010" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10011" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10100" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10110" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11000" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11001" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11010" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11011" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11100" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11110" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "1111";
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN others =>
					end case;

				when x"CB" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1010";
							n_mend_o     <= '0';
						when "00010" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "1010";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1010";
							n_mend_o     <= '0';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1010";
							n_mend_o     <= '0';
						WHEN "00110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1010";
							n_mend_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1010";
							n_mend_o     <= '0';
						WHEN "01010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1010";
							n_mend_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1010";
							n_mend_o     <= '0';
						WHEN "01110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1010";
							n_mend_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1010";
							n_mend_o     <= '0';
						WHEN "10010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1010";
							n_mend_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1010";
							n_mend_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1010";
							n_mend_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1010";
							n_mend_o     <= '0';
						WHEN "11010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1010";
							n_mend_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1010";
							n_mend_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1010";
							n_mend_o     <= '0';
						WHEN others =>
					end case;

				when x"CC" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1101";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01011" =>
							alu_mode_o   <= "1010";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01100" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1010";
							adrsel_o     <= '0';
						when "01101" =>
							alu_mode_o   <= "1010";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01110" =>
							clocks_o     <= "0111";
							enable_o     <= "1101";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01111" =>
							intern_o     <= '1';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "11100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"CD" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1101";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01011" =>
							alu_mode_o   <= "1010";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01100" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1010";
							adrsel_o     <= '0';
						when "01101" =>
							alu_mode_o   <= "1010";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01110" =>
							clocks_o     <= "0111";
							enable_o     <= "1101";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01111" =>
							intern_o     <= '1';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "11100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"CE" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1101";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01011" =>
							alu_mode_o   <= "1011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01100" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1011";
							adrsel_o     <= '0';
						when "01101" =>
							alu_mode_o   <= "1011";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01110" =>
							clocks_o     <= "0111";
							enable_o     <= "1101";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01111" =>
							intern_o     <= '1';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "11100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"CF" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1101";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01011" =>
							alu_mode_o   <= "1011";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01100" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1011";
							adrsel_o     <= '0';
						when "01101" =>
							alu_mode_o   <= "1011";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01110" =>
							clocks_o     <= "0111";
							enable_o     <= "1101";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01111" =>
							intern_o     <= '1';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "11100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"D0" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						when "00011" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN others =>
					end case;

				when x"D1" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00100" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "00101" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"D2" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						when "00100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						when "00101" =>
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "00111" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN others =>
					end case;

				when x"D3" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1101";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01100" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01101" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "11100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"D4" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1101";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01100" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01101" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "11100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"D5" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01001" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "01011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"D6" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01001" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "01011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"D7" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							n_mend_o     <= '0';
						when "00010" =>
							intern_o     <= '1';
						WHEN "00011" =>
							n_mend_o     <= '0';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							n_mend_o     <= '0';
						WHEN "00110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							n_mend_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							n_mend_o     <= '0';
						WHEN "01010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							n_mend_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							n_mend_o     <= '0';
						WHEN "01110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							n_mend_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							n_mend_o     <= '0';
						WHEN "10010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							n_mend_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							n_mend_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							n_mend_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							n_mend_o     <= '0';
						WHEN "11010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							n_mend_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							n_mend_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							n_mend_o     <= '0';
						WHEN others =>
					end case;

				when x"D8" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01001" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "01011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"D9" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01001" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "01011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"DA" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_mend_o     <= '0';
						when "00100" =>
							clocks_o     <= "1000";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							intern_o     <= '1';
						WHEN "00110" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "00111" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_mend_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_mend_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01111" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_mend_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_mend_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10111" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_mend_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_mend_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "1000";
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11111" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_mend_o     <= '0';
						WHEN others =>
					end case;

				when x"DB" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1011";
							n_mend_o     <= '0';
						when "00010" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "1011";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1011";
							n_mend_o     <= '0';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1011";
							n_mend_o     <= '0';
						WHEN "00110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1011";
							n_mend_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1011";
							n_mend_o     <= '0';
						WHEN "01010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1011";
							n_mend_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1011";
							n_mend_o     <= '0';
						WHEN "01110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1011";
							n_mend_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1011";
							n_mend_o     <= '0';
						WHEN "10010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1011";
							n_mend_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1011";
							n_mend_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1011";
							n_mend_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1011";
							n_mend_o     <= '0';
						WHEN "11010" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1011";
							n_mend_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1011";
							n_mend_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "1011";
							n_mend_o     <= '0';
						WHEN others =>
					end case;

				when x"DC" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						when "00011" =>
							alu_mode_o   <= "1100";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1100";
							adrsel_o     <= '0';
						when "00101" =>
							alu_mode_o   <= "1100";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "00110" =>
							clocks_o     <= "0111";
							enable_o     <= "1101";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "00111" =>
							intern_o     <= '1';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "01011" =>
							alu_mode_o   <= "1100";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "01111" =>
							alu_mode_o   <= "1100";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "10011" =>
							alu_mode_o   <= "1100";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "10111" =>
							alu_mode_o   <= "1100";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "11011" =>
							alu_mode_o   <= "1100";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
						WHEN "11111" =>
							alu_mode_o   <= "1100";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN others =>
					end case;

				when x"DD" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							intern_o     <= '1';
						when "00100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						when "00101" =>
							alu_mode_o   <= "1100";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1100";
							adrsel_o     <= '0';
						when "00111" =>
							alu_mode_o   <= "1100";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01000" =>
							clocks_o     <= "0111";
							enable_o     <= "1101";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01001" =>
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						WHEN "01101" =>
							alu_mode_o   <= "1100";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1100";
							adrsel_o     <= '0';
						WHEN "01111" =>
							alu_mode_o   <= "1100";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							intern_o     <= '1';
						WHEN "10100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						WHEN "10101" =>
							alu_mode_o   <= "1100";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1100";
							adrsel_o     <= '0';
						WHEN "10111" =>
							alu_mode_o   <= "1100";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							intern_o     <= '1';
						WHEN "11100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						WHEN "11101" =>
							alu_mode_o   <= "1100";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1100";
							adrsel_o     <= '0';
						WHEN "11111" =>
							alu_mode_o   <= "1100";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						WHEN others =>
					end case;

				when x"DE" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							alu_mode_o   <= "1100";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1100";
							adrsel_o     <= '0';
						when "01001" =>
							alu_mode_o   <= "1100";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01010" =>
							clocks_o     <= "0111";
							enable_o     <= "1101";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01011" =>
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							alu_mode_o   <= "1100";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							alu_mode_o   <= "1100";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							alu_mode_o   <= "1100";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"DF" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							alu_mode_o   <= "1100";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "1100";
							adrsel_o     <= '0';
						when "01001" =>
							alu_mode_o   <= "1100";
							n_alu_ldfc_o <= '0';
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01010" =>
							clocks_o     <= "0111";
							enable_o     <= "1101";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01011" =>
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							alu_mode_o   <= "1100";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							alu_mode_o   <= "1100";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							alu_mode_o   <= "1100";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"E0" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0001";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0001";
							n_incpc_o    <= '0';
							n_mend_o     <= '0';
						when "00011" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0001";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0001";
							intern_o     <= '1';
						WHEN others =>
					end case;

				when x"E1" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00100" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0001";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "00101" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0001";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"E2" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						when "00100" =>
							clocks_o     <= "0011";
							enable_o     <= "0001";
						when "00101" =>
							alu_mode_o   <= "0001";
							intern_o     <= '1';
							adrsel_o     <= '0';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0001";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "00111" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0001";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01001" =>
							intern_o     <= '1';
						WHEN "01010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN "01100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01101" =>
							intern_o     <= '1';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN "10100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10101" =>
							intern_o     <= '1';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN "11100" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11101" =>
							intern_o     <= '1';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							intern_o     <= '1';
						WHEN others =>
					end case;

				when x"E3" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1101";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01100" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0001";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01101" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0001";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "11100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"E4" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						when "00100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "00101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						when "00110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1110";
							enable_o     <= "0010";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							adrsel_o     <= '0';
							n_aluclk_o   <= '0';
						when "01001" =>
							clocks_o     <= "0010";
							enable_o     <= "1101";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
						when "01010" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "01011" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01100" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0001";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01101" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0001";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "10100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "10110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "0011";
							enable_o     <= "0101";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1100";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11011" =>
							clocks_o     <= "0010";
							enable_o     <= "1100";
						WHEN "11100" =>
							clocks_o     <= "1110";
							enable_o     <= "1100";
							alu_mode_o   <= "1110";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11101" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "1110";
							adrsel_o     <= '0';
						WHEN "11110" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "1110";
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1011";
							alu_mode_o   <= "0011";
							alu_csel_o   <= '1';
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"E5" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "00001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						when "00010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						when "00011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						when "00100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						when "00101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						when "00110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						when "00111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						when "01000" =>
							clocks_o     <= "1111";
							enable_o     <= "0010";
							alu_mode_o   <= "0001";
							adrsel_o     <= '0';
							n_mend_o     <= '0';
						when "01001" =>
							clocks_o     <= "1001";
							enable_o     <= "1111";
							alu_mode_o   <= "0001";
							n_alu_ldvz_o <= '0';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "01011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "01100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "01101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "01110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "01111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "10000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "10001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "10010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "10011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "10100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "10101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "10110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "10111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN "11000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						WHEN "11001" =>
							clocks_o     <= "1110";
							enable_o     <= "1010";
							intern_o     <= '1';
						WHEN "11010" =>
							clocks_o     <= "1111";
							enable_o     <= "0001";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
						WHEN "11011" =>
							enable_o     <= "0101";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
							n_incpc_o    <= '0';
						WHEN "11100" =>
							clocks_o     <= "0010";
							enable_o     <= "1111";
							alu_mode_o   <= "0011";
							alu_fsel_o   <= '1';
							alu_csel_o   <= '1';
							intern_o     <= '1';
							n_aluclk_o   <= '0';
						WHEN "11101" =>
							clocks_o     <= "1110";
							enable_o     <= "0001";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_incpc_o    <= '0';
						WHEN "11110" =>
							clocks_o     <= "0011";
							enable_o     <= "1111";
							alu_mode_o   <= "1000";
							alu_csel_o   <= '1';
							n_aluclk_o   <= '0';
						WHEN "11111" =>
							clocks_o     <= "1110";
							enable_o     <= "1001";
							alu_mode_o   <= "0001";
							intern_o     <= '1';
							adrsel_o     <= '0';
						WHEN others =>
					end case;

				when x"E6" =>
					case mctr_i is
						when "00000" =>
							clocks_o     <= "0001";
							enable_o     <= "0001";
							n_incpc_o    <= '0';
						when "0