/*-----------------------------------------------------------------------------
 *
 *   Serial Interface / RS232 - Library for MS Windows and Linux
 *
 *   (c) in February 2010 by Dennis Kuschel, Germany
 *
 *   visit http://www.mycpu.eu for more information
 *
 *-----------------------------------------------------------------------------
 *
 *  Copyright (c) 2010, Dennis Kuschel.
 *  All rights reserved. 
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *   3. The name of the author may not be used to endorse or promote
 *      products derived from this software without specific prior written
 *      permission. 
 *
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 *  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 *  INDIRECT,  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *  STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 *  OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *---------------------------------------------------------------------------*/

#include "platform.h"
#ifdef _WIN32

#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include <ctype.h>

typedef struct SERPORT_s {
  HANDLE     hCom;
  OVERLAPPED ovlRd;
  OVERLAPPED ovlWr;
  int        rdPendFlag;
  char       wrComBt;
  char       rdComBt;
} *SERPORT_t;


#else /* LINUX */

#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <fcntl.h>
#include <termios.h>
#include <ctype.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/ioctl.h>

typedef int SERPORT_t;

#endif


/** Open a com-port for data transmission.
 *  @param port        returned value: handle to the port
 *  @param ttydevice   name of the device, e.g. ttyS1 for COM2
 *  @param baud        baudrate
 *  @param databits    number of data bits, must be 5, 6, 7 or 8
 *  @param stopbits    number of stop bits, must be 1 or 2
 *  @param parity      0:none, 1=odd, 2=even
 *  @param handshake   0:none, 1=hardware, 2=software
 *  @return  zero if the port was successfully set up.
 *           Other values denote errors.
 */
int serialOpen(SERPORT_t *port, const char *ttydevice, int baud, int databits, int stopbits, int parity, int handshake);


/** Closes a com-port.
 *  @param fd    handle to port
 */
void serialClose(SERPORT_t fd);


/** Output a byte on a com-port.
 *  @param fd       handle to the port
 *  @param data     data byte to send out
 *  @param timeout  timeout in microseconds. A timeout of zero means return immediately.
 *  @return  1 when the byte could be transmitted. 0 if not. -1 denotes an error.
 */
int serialOutput(SERPORT_t fd, unsigned char data, unsigned long timeout);


/** Receive a byte from a com-port.
 *  @param fd       handle to the port
 *  @param pdata    pointer to buffer for data receive
 *  @param timeout  timeout in microseconds. A timeout of zero means return immediately.
 *  @return  1 when a byte was received. 0 if not. -1 denotes an error.
 */
int serialInput(SERPORT_t fd, unsigned char *pdata, unsigned timeout);
